/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class NameValidator
extends DefaultValidator {
    private final Set<String> prefixes;

    NameValidator(Set<String> prefixes) {
        this.prefixes = prefixes;
    }

    protected void checkValidName(String name) throws CommitFailedException {
        String prefix;
        int colon = name.indexOf(58);
        if (colon > 0 && ((prefix = name.substring(0, colon)).isEmpty() || !this.prefixes.contains(prefix))) {
            throw new CommitFailedException("Name", 1, "Invalid namespace prefix(" + this.prefixes + "): " + prefix);
        }
        String local = name.substring(colon + 1);
        int n = local.length();
        if (n > 3 && local.charAt(n - 1) == ']') {
            int i;
            for (i = n - 2; i > 1 && Character.isDigit(local.charAt(i)); --i) {
            }
            if (local.charAt(i) != '[') {
                throw new CommitFailedException("Name", 2, "Invalid name index " + name);
            }
            local = local.substring(0, i);
        }
        if (!Namespaces.isValidLocalName(local)) {
            throw new CommitFailedException("Name", 3, "Invalid name: " + name);
        }
    }

    protected void checkValidValue(PropertyState property) throws CommitFailedException {
        if (Type.NAME.equals(property.getType())) {
            for (String value : property.getValue(Type.NAMES)) {
                this.checkValidValue(value);
            }
        }
    }

    protected void checkValidValue(String value) throws CommitFailedException {
        this.checkValidName(value);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.checkValidName(after.getName());
        this.checkValidValue(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.checkValidValue(after);
    }

    @Override
    public void propertyDeleted(PropertyState before) {
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        this.checkValidName(name);
        return this;
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        return this;
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) {
        return null;
    }
}

