/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.kernel.BlobSerializer;
import org.apache.jackrabbit.oak.kernel.JsopDiff;
import org.apache.jackrabbit.oak.kernel.KernelBlob;
import org.apache.jackrabbit.oak.kernel.KernelNodeState;
import org.apache.jackrabbit.oak.kernel.KernelNodeStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeStoreBranch;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class KernelNodeStoreBranch
extends AbstractNodeStoreBranch<KernelNodeStore, KernelNodeState> {
    private final BlobSerializer blobs = new BlobSerializer(){

        @Override
        public String serialize(Blob blob) {
            KernelBlob kernelBlob;
            if (blob instanceof KernelBlob) {
                kernelBlob = (KernelBlob)blob;
            } else {
                try {
                    kernelBlob = ((KernelNodeStore)KernelNodeStoreBranch.this.store).createBlob(blob.getNewStream());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            return kernelBlob.getBinaryID();
        }
    };

    public KernelNodeStoreBranch(KernelNodeStore kernelNodeStore, ChangeDispatcher dispatcher, Lock mergeLock, KernelNodeState base) {
        super(kernelNodeStore, dispatcher, mergeLock, base);
    }

    @Override
    public KernelNodeState createBranch(KernelNodeState state) {
        return ((KernelNodeStore)this.store).branch(state);
    }

    @Override
    public KernelNodeState getRoot() {
        return ((KernelNodeStore)this.store).getRoot();
    }

    @Override
    protected KernelNodeState rebase(KernelNodeState branchHead, KernelNodeState base) {
        return ((KernelNodeStore)this.store).rebase(branchHead, base);
    }

    @Override
    protected KernelNodeState merge(KernelNodeState branchHead, CommitInfo info) throws CommitFailedException {
        try {
            return ((KernelNodeStore)this.store).merge(branchHead);
        }
        catch (MicroKernelException e) {
            throw new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying MicroKernel", e);
        }
    }

    @Override
    @Nonnull
    protected KernelNodeState reset(@Nonnull KernelNodeState branchHead, @Nonnull KernelNodeState ancestor) {
        return ((KernelNodeStore)this.store).reset(branchHead, ancestor);
    }

    @Override
    protected KernelNodeState persist(NodeState toPersist, KernelNodeState base, CommitInfo info) {
        JsopDiff diff = new JsopDiff(this.blobs);
        toPersist.compareAgainstBaseState(base, diff);
        return ((KernelNodeStore)this.store).commit(diff.toString(), base);
    }

    @Override
    protected KernelNodeState copy(String source, String target, KernelNodeState base) {
        return ((KernelNodeStore)this.store).commit("*\"" + source + "\":\"" + target + '\"', base);
    }

    @Override
    protected KernelNodeState move(String source, String target, KernelNodeState base) {
        return ((KernelNodeStore)this.store).commit(">\"" + source + "\":\"" + target + '\"', base);
    }

    @Override
    @Nonnull
    public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        try {
            return super.merge(hook, info);
        }
        catch (MicroKernelException e) {
            throw new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying MicroKernel", e);
        }
    }
}

