/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.gridfs;

import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.Command;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.CommandExecutor;

public class DefaultCommandExecutor
implements CommandExecutor {
    @Override
    public <T> T execute(Command<T> command) throws IOException {
        try {
            return this.executeCommand(command);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T> T executeCommand(Command<T> command) throws Exception {
        Object result = null;
        int numOfRetries = command.getNumOfRetries();
        boolean needsRetry = true;
        for (int currentRetry = 0; currentRetry <= numOfRetries && needsRetry; ++currentRetry) {
            try {
                result = command.execute();
                needsRetry = command.needsRetry(result);
                continue;
            }
            catch (Exception e) {
                needsRetry = command.needsRetry(e);
                if (needsRetry && currentRetry < numOfRetries) continue;
                throw e;
            }
        }
        return result;
    }
}

