/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.xpath;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.xpath.Expression;
import org.apache.jackrabbit.oak.query.xpath.Order;
import org.apache.jackrabbit.oak.query.xpath.Selector;
import org.apache.jackrabbit.oak.query.xpath.Statement;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathToSQL2Converter {
    static final Logger LOG = LoggerFactory.getLogger(XPathToSQL2Converter.class);
    private static final int CHAR_END = -1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DECIMAL = 8;
    private static final int KEYWORD = 1;
    private static final int IDENTIFIER = 2;
    private static final int END = 4;
    private static final int VALUE_STRING = 5;
    private static final int VALUE_NUMBER = 6;
    private static final int MINUS = 12;
    private static final int PLUS = 13;
    private static final int OPEN = 14;
    private static final int CLOSE = 15;
    private String statement;
    private char[] statementChars;
    private int[] characterTypes;
    private int parseIndex;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private ArrayList<String> expected;
    private Selector currentSelector = new Selector();
    private ArrayList<Selector> selectors = new ArrayList();

    public String convert(String query) throws ParseException {
        query = query.trim();
        Statement statement = new Statement();
        if (query.startsWith("explain ")) {
            query = query.substring("explain".length()).trim();
            statement.setExplain(true);
        }
        if (query.startsWith("measure")) {
            query = query.substring("measure".length()).trim();
            statement.setMeasure(true);
        }
        if (query.isEmpty()) {
            query = "//jcr:root";
        }
        statement.setOriginalQuery(query);
        this.initialize(query);
        this.expected = new ArrayList();
        this.read();
        if (this.currentTokenType == 4) {
            throw this.getSyntaxError("the query may not be empty");
        }
        this.currentSelector.name = "a";
        String pathPattern = "";
        boolean startOfQuery = true;
        while (true) {
            boolean shortcut = false;
            boolean slash = this.readIf("/");
            if (!slash) {
                if (!startOfQuery) break;
                this.currentSelector.path = "/";
                pathPattern = "/";
                this.currentSelector.isChild = true;
            } else if (this.readIf("jcr:root")) {
                if (!pathPattern.isEmpty()) {
                    throw this.getSyntaxError("jcr:root needs to be at the beginning");
                }
                if (this.readIf("/")) {
                    this.currentSelector.path = "/";
                    pathPattern = "/";
                    if (this.readIf("/")) {
                        pathPattern = "//";
                        this.currentSelector.isDescendant = true;
                    } else {
                        this.currentSelector.isChild = true;
                    }
                } else {
                    pathPattern = "/%";
                    this.currentSelector.path = "/";
                    shortcut = true;
                }
            } else if (this.readIf("/")) {
                pathPattern = pathPattern + "%";
                this.currentSelector.isDescendant = true;
            } else {
                pathPattern = pathPattern + "/";
                if (startOfQuery) {
                    this.currentSelector.path = "/";
                } else {
                    this.currentSelector.isChild = true;
                }
            }
            if (!shortcut) {
                Expression.Property p;
                String name;
                if (this.readIf("*")) {
                    pathPattern = pathPattern + "%";
                    if (!this.currentSelector.isDescendant && this.selectors.size() == 0 && this.currentSelector.path.equals("")) {
                        this.currentSelector.path = "/";
                    }
                } else if (this.readIf("text")) {
                    this.currentSelector.isChild = false;
                    pathPattern = pathPattern + "jcr:xmltext";
                    this.read("(");
                    this.read(")");
                    if (this.currentSelector.isDescendant) {
                        this.currentSelector.nodeName = "jcr:xmltext";
                    } else {
                        this.currentSelector.path = PathUtils.concat(this.currentSelector.path, "jcr:xmltext");
                    }
                } else if (this.readIf("element")) {
                    this.read("(");
                    if (this.readIf(")")) {
                        pathPattern = pathPattern + "%";
                    } else {
                        if (this.readIf("*")) {
                            pathPattern = pathPattern + "%";
                        } else {
                            name = this.readPathSegment();
                            pathPattern = pathPattern + name;
                            this.appendNodeName(name);
                        }
                        if (this.readIf(",")) {
                            this.currentSelector.nodeType = this.readIdentifier();
                        }
                        this.read(")");
                    }
                } else if (this.readIf("@")) {
                    this.rewindSelector();
                    p = this.readProperty();
                    statement.addSelectColumn(p);
                } else if (this.readIf("rep:excerpt")) {
                    this.rewindSelector();
                    this.readExcerpt();
                    p = new Expression.Property(this.currentSelector, "rep:excerpt", false);
                    statement.addSelectColumn(p);
                } else if (this.readIf("(")) {
                    this.rewindSelector();
                    do {
                        if (this.readIf("@")) {
                            p = this.readProperty();
                            statement.addSelectColumn(p);
                            continue;
                        }
                        if (!this.readIf("rep:excerpt")) continue;
                        this.readExcerpt();
                        p = new Expression.Property(this.currentSelector, "rep:excerpt", false);
                        statement.addSelectColumn(p);
                    } while (this.readIf("|"));
                    this.read(")");
                } else if (this.currentTokenType == 2) {
                    name = this.readPathSegment();
                    pathPattern = pathPattern + name;
                    this.appendNodeName(name);
                } else if (this.readIf(".")) {
                    if (this.readIf(".")) {
                        name = "..";
                        pathPattern = pathPattern + name;
                        if (!this.currentSelector.isChild) {
                            this.currentSelector.nodeName = name;
                        } else if (this.currentSelector.isChild) {
                            this.currentSelector.isChild = false;
                            this.currentSelector.isParent = true;
                        }
                    } else if (this.selectors.size() > 0) {
                        this.currentSelector = this.selectors.remove(this.selectors.size() - 1);
                        this.currentSelector.condition = null;
                        this.currentSelector.joinCondition = null;
                    }
                } else {
                    throw this.getSyntaxError();
                }
            }
            if (this.readIf("[")) {
                Expression c = this.parseConstraint();
                this.currentSelector.condition = Expression.and(this.currentSelector.condition, c);
                this.read("]");
            }
            startOfQuery = false;
            this.nextSelector(false);
        }
        if (this.selectors.size() == 0) {
            this.nextSelector(true);
        }
        this.currentSelector = this.selectors.get(this.selectors.size() - 1);
        if (this.selectors.size() == 1) {
            this.currentSelector.onlySelector = true;
        }
        if (this.readIf("order")) {
            this.read("by");
            do {
                Order order = new Order();
                order.expr = this.parseExpression();
                if (this.readIf("descending")) {
                    order.descending = true;
                } else {
                    this.readIf("ascending");
                }
                statement.addOrderBy(order);
            } while (this.readIf(","));
        }
        if (!this.currentToken.isEmpty()) {
            throw this.getSyntaxError("<end>");
        }
        statement.setColumnSelector(this.currentSelector);
        statement.setSelectors(this.selectors);
        Expression where = null;
        for (Selector s : this.selectors) {
            where = Expression.and(where, s.condition);
        }
        statement.setWhere(where);
        statement = statement.optimize();
        return statement.toString();
    }

    private void appendNodeName(String name) {
        if (!this.currentSelector.isChild) {
            this.currentSelector.nodeName = name;
        } else if (this.selectors.size() > 0) {
            this.currentSelector.isChild = true;
            this.currentSelector.nodeName = name;
        } else {
            this.currentSelector.isChild = false;
            String oldPath = this.currentSelector.path;
            this.currentSelector.path = PathUtils.concat(oldPath, name);
        }
    }

    private void rewindSelector() {
        if (this.selectors.size() > 0) {
            this.currentSelector = this.selectors.remove(this.selectors.size() - 1);
            this.currentSelector.isChild = false;
            this.currentSelector.isDescendant = false;
            this.currentSelector.path = "";
            this.currentSelector.nodeName = null;
        }
    }

    private void nextSelector(boolean force) throws ParseException {
        Expression.Function c;
        boolean isFirstSelector = this.selectors.size() == 0;
        String path = this.currentSelector.path;
        Expression condition = this.currentSelector.condition;
        Expression.Function joinCondition = null;
        if (this.currentSelector.nodeName != null) {
            Expression.Function f = new Expression.Function("name");
            f.params.add(new Expression.SelectorExpr(this.currentSelector));
            String n = this.currentSelector.nodeName;
            n = ISO9075.encode(n);
            Expression.Condition c2 = new Expression.Condition(f, "=", Expression.Literal.newString(n), 3);
            condition = Expression.and(condition, c2);
        }
        if (this.currentSelector.isDescendant) {
            if (isFirstSelector) {
                if (!path.isEmpty()) {
                    if (!PathUtils.isAbsolute(path)) {
                        path = PathUtils.concat("/", path);
                    }
                    c = new Expression.Function("isdescendantnode");
                    c.params.add(new Expression.SelectorExpr(this.currentSelector));
                    c.params.add(Expression.Literal.newString(path));
                    condition = Expression.and(condition, c);
                }
            } else {
                c = new Expression.Function("isdescendantnode");
                c.params.add(new Expression.SelectorExpr(this.currentSelector));
                c.params.add(new Expression.SelectorExpr(this.selectors.get(this.selectors.size() - 1)));
                joinCondition = c;
            }
        } else if (this.currentSelector.isParent) {
            if (isFirstSelector) {
                throw this.getSyntaxError();
            }
            c = new Expression.Function("ischildnode");
            c.params.add(new Expression.SelectorExpr(this.selectors.get(this.selectors.size() - 1)));
            c.params.add(new Expression.SelectorExpr(this.currentSelector));
            joinCondition = c;
        } else if (this.currentSelector.isChild) {
            if (isFirstSelector) {
                if (!path.isEmpty()) {
                    if (!PathUtils.isAbsolute(path)) {
                        path = PathUtils.concat("/", path);
                    }
                    c = new Expression.Function("ischildnode");
                    c.params.add(new Expression.SelectorExpr(this.currentSelector));
                    c.params.add(Expression.Literal.newString(path));
                    condition = Expression.and(condition, c);
                }
            } else {
                c = new Expression.Function("ischildnode");
                c.params.add(new Expression.SelectorExpr(this.currentSelector));
                c.params.add(new Expression.SelectorExpr(this.selectors.get(this.selectors.size() - 1)));
                joinCondition = c;
            }
        } else if ((force || condition != null || joinCondition != null) && PathUtils.isAbsolute(path)) {
            c = new Expression.Function("issamenode");
            c.params.add(new Expression.SelectorExpr(this.currentSelector));
            c.params.add(Expression.Literal.newString(path));
            condition = Expression.and(condition, c);
        }
        if (force || condition != null || joinCondition != null) {
            String nextSelectorName = "" + (char)(this.currentSelector.name.charAt(0) + '\u0001');
            if (nextSelectorName.compareTo("x") > 0) {
                throw this.getSyntaxError("too many joins");
            }
            Selector nextSelector = new Selector();
            nextSelector.name = nextSelectorName;
            this.currentSelector.condition = condition;
            this.currentSelector.joinCondition = Expression.and(this.currentSelector.joinCondition, joinCondition);
            this.selectors.add(this.currentSelector);
            this.currentSelector = nextSelector;
        }
    }

    private Expression parseConstraint() throws ParseException {
        Expression a = this.parseAnd();
        while (this.readIf("or")) {
            a = new Expression.OrCondition(a, this.parseAnd());
        }
        return a;
    }

    private Expression parseAnd() throws ParseException {
        Expression a = this.parseCondition();
        while (this.readIf("and")) {
            a = new Expression.AndCondition(a, this.parseCondition());
        }
        return a;
    }

    private Expression parseCondition() throws ParseException {
        Expression a;
        if (this.readIf("fn:not") || this.readIf("not")) {
            this.read("(");
            a = this.parseConstraint();
            if (a instanceof Expression.Condition && ((Expression.Condition)a).operator.equals("is not null")) {
                Expression.Condition c = (Expression.Condition)a;
                c = new Expression.Condition(c.left, "is null", null, 3);
                a = c;
            } else {
                Expression.Function f = new Expression.Function("not");
                f.params.add(a);
                a = f;
            }
            this.read(")");
        } else if (this.readIf("(")) {
            a = this.parseConstraint();
            this.read(")");
        } else {
            Expression e = this.parseExpression();
            if (e.isCondition()) {
                return e;
            }
            a = this.parseCondition(e);
        }
        return a;
    }

    private Expression.Condition parseCondition(Expression left) throws ParseException {
        Expression.Condition c = this.readIf("=") ? new Expression.Condition(left, "=", this.parseExpression(), 3) : (this.readIf("<>") ? new Expression.Condition(left, "<>", this.parseExpression(), 3) : (this.readIf("!=") ? new Expression.Condition(left, "<>", this.parseExpression(), 3) : (this.readIf("<") ? new Expression.Condition(left, "<", this.parseExpression(), 3) : (this.readIf(">") ? new Expression.Condition(left, ">", this.parseExpression(), 3) : (this.readIf("<=") ? new Expression.Condition(left, "<=", this.parseExpression(), 3) : (this.readIf(">=") ? new Expression.Condition(left, ">=", this.parseExpression(), 3) : new Expression.Condition(left, "is not null", null, 3)))))));
        return c;
    }

    private Expression parseExpression() throws ParseException {
        if (this.readIf("@")) {
            return this.readProperty();
        }
        if (this.readIf("true")) {
            return Expression.Literal.newBoolean(true);
        }
        if (this.readIf("false")) {
            return Expression.Literal.newBoolean(false);
        }
        if (this.currentTokenType == 6) {
            Expression.Literal l = Expression.Literal.newNumber(this.currentToken);
            this.read();
            return l;
        }
        if (this.currentTokenType == 5) {
            Expression.Literal l = Expression.Literal.newString(this.currentToken);
            this.read();
            return l;
        }
        if (this.readIf("-")) {
            if (this.currentTokenType != 6) {
                throw this.getSyntaxError();
            }
            Expression.Literal l = Expression.Literal.newNumber('-' + this.currentToken);
            this.read();
            return l;
        }
        if (this.readIf("+")) {
            if (this.currentTokenType != 6) {
                throw this.getSyntaxError();
            }
            return this.parseExpression();
        }
        return this.parsePropertyOrFunction();
    }

    private Expression parsePropertyOrFunction() throws ParseException {
        StringBuilder buff = new StringBuilder();
        boolean isPath = false;
        while (true) {
            if (this.currentTokenType == 2) {
                String name = this.readPathSegment();
                buff.append(name);
            } else if (this.readIf("*")) {
                buff.append('*');
                isPath = true;
            } else if (this.readIf(".")) {
                buff.append('.');
                if (this.readIf(".")) {
                    buff.append('.');
                }
                isPath = true;
            } else {
                if (!this.readIf("@")) break;
                if (this.readIf("*")) {
                    buff.append('*');
                } else {
                    buff.append(this.readPathSegment());
                }
                return new Expression.Property(this.currentSelector, buff.toString(), false);
            }
            if (!this.readIf("/")) break;
            isPath = true;
            buff.append('/');
        }
        if (!isPath && this.readIf("(")) {
            return this.parseFunction(buff.toString());
        }
        if (buff.length() > 0) {
            if (buff.toString().equals(".")) {
                return new Expression.Property(this.currentSelector, "*", false);
            }
            return new Expression.Property(this.currentSelector, buff.toString(), true);
        }
        throw this.getSyntaxError();
    }

    private Expression parseFunction(String functionName) throws ParseException {
        if ("jcr:like".equals(functionName)) {
            Expression.Condition c = new Expression.Condition(this.parseExpression(), "like", null, 3);
            this.read(",");
            c.right = this.parseExpression();
            this.read(")");
            return c;
        }
        if ("jcr:contains".equals(functionName)) {
            Expression left = this.parseExpression();
            this.read(",");
            Expression right = this.parseExpression();
            this.read(")");
            Expression.Contains f = new Expression.Contains(left, right);
            return f;
        }
        if ("jcr:score".equals(functionName)) {
            Expression.Function f = new Expression.Function("score");
            f.params.add(new Expression.SelectorExpr(this.currentSelector));
            this.read(")");
            return f;
        }
        if ("xs:dateTime".equals(functionName)) {
            Expression expr = this.parseExpression();
            Expression.Cast c = new Expression.Cast(expr, "date");
            this.read(")");
            return c;
        }
        if ("fn:lower-case".equals(functionName)) {
            Expression.Function f = new Expression.Function("lower");
            f.params.add(this.parseExpression());
            this.read(")");
            return f;
        }
        if ("fn:upper-case".equals(functionName)) {
            Expression.Function f = new Expression.Function("upper");
            f.params.add(this.parseExpression());
            this.read(")");
            return f;
        }
        if ("fn:name".equals(functionName)) {
            Expression.Function f = new Expression.Function("name");
            if (!this.readIf(")")) {
                this.read(".");
                this.read(")");
            }
            f.params.add(new Expression.SelectorExpr(this.currentSelector));
            return f;
        }
        if ("jcr:deref".equals(functionName)) {
            throw this.getSyntaxError("jcr:deref is not supported");
        }
        if ("rep:native".equals(functionName)) {
            String selectorName = this.currentSelector.name;
            Expression language = this.parseExpression();
            this.read(",");
            Expression expr = this.parseExpression();
            this.read(")");
            Expression.NativeFunction f = new Expression.NativeFunction(selectorName, language, expr);
            return f;
        }
        if ("rep:similar".equals(functionName)) {
            Expression property = this.parseExpression();
            this.read(",");
            Expression path = this.parseExpression();
            this.read(")");
            Expression.Similar f = new Expression.Similar(property, path);
            return f;
        }
        if ("rep:spellcheck".equals(functionName)) {
            throw this.getSyntaxError("rep:spellcheck is not supported");
        }
        throw this.getSyntaxError("jcr:like | jcr:contains | jcr:score | xs:dateTime | fn:lower-case | fn:upper-case | fn:name");
    }

    private boolean readIf(String token) throws ParseException {
        if (this.isToken(token)) {
            this.read();
            return true;
        }
        return false;
    }

    private boolean isToken(String token) {
        boolean result;
        boolean bl = result = token.equals(this.currentToken) && !this.currentTokenQuoted;
        if (result) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private void read(String expected) throws ParseException {
        if (!expected.equals(this.currentToken) || this.currentTokenQuoted) {
            throw this.getSyntaxError(expected);
        }
        this.read();
    }

    private Expression.Property readProperty() throws ParseException {
        if (this.readIf("*")) {
            return new Expression.Property(this.currentSelector, "*", false);
        }
        return new Expression.Property(this.currentSelector, this.readPathSegment(), false);
    }

    private void readExcerpt() throws ParseException {
        this.read("(");
        if (!this.readIf(")")) {
            this.read(".");
            this.read(")");
        }
    }

    private String readPathSegment() throws ParseException {
        String raw = this.readIdentifier();
        return ISO9075.decode(raw);
    }

    private String readIdentifier() throws ParseException {
        if (this.currentTokenType != 2) {
            throw this.getSyntaxError("identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private void addExpected(String token) {
        if (this.expected != null) {
            this.expected.add(token);
        }
    }

    private void initialize(String query) throws ParseException {
        if (query == null) {
            query = "";
        }
        this.statement = query;
        int len = query.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        query.getChars(0, --len, command, 0);
        command[len] = 32;
        int startLoop = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            switch (c) {
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '\'': {
                    type = 7;
                    types[i] = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '\"': {
                    type = 7;
                    types[i] = 7;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case ':': 
                case '_': {
                    type = 4;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z') {
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    type = 4;
                }
            }
            types[i] = (byte)type;
        }
        this.statementChars = command;
        types[len] = -1;
        this.characterTypes = types;
        this.parseIndex = 0;
    }

    private void checkRunOver(int i, int len, int startLoop) throws ParseException {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    private void read() throws ParseException {
        this.currentTokenQuoted = false;
        if (this.expected != null) {
            this.expected.clear();
        }
        int[] types = this.characterTypes;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.statementChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while ((type = types[i]) == 4 || type == 2 || chars[i] == '-' || chars[i] == '.') {
                    ++i;
                }
                this.currentToken = this.statement.substring(start, i);
                if (this.currentToken.isEmpty()) {
                    throw this.getSyntaxError();
                }
                this.currentTokenType = 2;
                this.parseIndex = i;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    ++i;
                }
                this.currentToken = this.statement.substring(start, i);
                this.currentTokenType = 1;
                this.parseIndex = i;
                break;
            }
            case 5: {
                this.currentToken = this.statement.substring(start, i);
                switch (c) {
                    case '+': {
                        this.currentTokenType = 13;
                        break;
                    }
                    case '-': {
                        this.currentTokenType = 12;
                        break;
                    }
                    case '(': {
                        this.currentTokenType = 14;
                        break;
                    }
                    case ')': {
                        this.currentTokenType = 15;
                        break;
                    }
                    default: {
                        this.currentTokenType = 1;
                    }
                }
                this.parseIndex = i;
                return;
            }
            case 2: {
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(start, i);
                            break;
                        }
                        if (c == 'E' || c == 'e') {
                            this.readDecimal(start, i);
                            break;
                        }
                        this.currentTokenType = 6;
                        this.currentToken = String.valueOf(number);
                        this.parseIndex = i;
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i);
                return;
            }
            case 7: {
                if (chars[i - 1] == '\'') {
                    this.readString(i, '\'');
                } else {
                    this.readString(i, '\"');
                }
                return;
            }
            case -1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = i;
                return;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
    }

    private void readString(int i, char end) throws ParseException {
        char[] chars = this.statementChars;
        String result = null;
        while (true) {
            int begin = ++i;
            while (true) {
                if (chars[i] == end) {
                    if (result == null) {
                        result = this.statement.substring(begin, i);
                        break;
                    }
                    result = result + this.statement.substring(begin - 1, i);
                    break;
                }
                ++i;
            }
            if (chars[++i] != end) break;
        }
        this.currentToken = result;
        this.parseIndex = i;
        this.currentTokenType = 5;
    }

    private void readDecimal(int start, int i) throws ParseException {
        int t;
        char[] chars = this.statementChars;
        int[] types = this.characterTypes;
        while ((t = types[i]) == 8 || t == 2) {
            ++i;
        }
        if (chars[i] == 'E' || chars[i] == 'e') {
            if (chars[++i] == '+' || chars[i] == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        String sub = this.statement.substring(start, i);
        try {
            new BigDecimal(sub);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Data conversion error converting " + sub + " to BigDecimal: " + e, i);
        }
        this.currentToken = sub;
        this.currentTokenType = 6;
    }

    private ParseException getSyntaxError() {
        if (this.expected == null || this.expected.isEmpty()) {
            return this.getSyntaxError(null);
        }
        StringBuilder buff = new StringBuilder();
        for (String exp : this.expected) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(exp);
        }
        return this.getSyntaxError(buff.toString());
    }

    private ParseException getSyntaxError(String expected) {
        int index = Math.max(0, Math.min(this.parseIndex, this.statement.length() - 1));
        String query = this.statement.substring(0, index) + "(*)" + this.statement.substring(index).trim();
        if (expected != null) {
            query = query + "; expected: " + expected;
        }
        return new ParseException("Query:\n" + query, index);
    }
}

