/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.plugin;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.configuration.Constant;
import org.gcube.accounting.aggregator.configuration.ManagementFileBackup;
import org.gcube.accounting.aggregator.madeaggregation.Aggregation;
import org.gcube.accounting.aggregator.madeaggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceBackendQueryConfiguration;
import org.gcube.accounting.aggregator.plugin.AccountingAggregatorPluginDeclaration;
import org.gcube.accounting.aggregator.plugin.DesignID;
import org.gcube.accounting.aggregator.plugin.Utility;
import org.gcube.accounting.aggregator.plugin.WorkSpaceManagement;
import org.gcube.accounting.aggregator.recovery.RecoveryRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedPortletUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedTaskUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.PortletUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.TaskUsageRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.PersistenceCouchBase;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingAggregatorPlugin
extends Plugin<AccountingAggregatorPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingAggregatorPlugin.class);
    public Bucket accountingBucket;
    protected Cluster cluster;
    public Aggregation aggregate;
    public static final String AGGREGATED = "aggregated";
    private static final String LINE_FREFIX = "{";
    private static final String LINE_SUFFIX = "}";
    private static final String KEY_VALUE_PAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_LINKER = "=";
    public static Integer countInsert = 0;
    public static Integer countDelete = 0;
    public static Integer recoveryMode = 0;
    public Boolean backup = true;
    public static Integer typePersisted = 0;
    protected PersistTo persisted;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(Constant.CONNECTION_TIMEOUT * 1000).maxRequestLifetime(Constant.MAX_REQUEST_LIFE_TIME * 1000).queryTimeout(Constant.CONNECTION_TIMEOUT * 1000).viewTimeout(Constant.VIEW_TIMEOUT_BUCKET * 1000).keepAliveInterval(3600000L).kvTimeout(5000L).build();

    public AccountingAggregatorPlugin(AccountingAggregatorPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        AggregatorPersistenceBackendQueryConfiguration configuration;
        countInsert = 0;
        countDelete = 0;
        if (inputs == null || inputs.isEmpty()) {
            logger.debug("{} inputs {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), inputs);
            throw new Exception("Inputs null");
        }
        if (!inputs.containsKey("type") || !inputs.containsKey("interval")) {
            throw new IllegalArgumentException("Interval and type must be defined");
        }
        AggregationType aggType = AggregationType.valueOf((String)inputs.get("type"));
        Integer intervaTot = (Integer)inputs.get("interval");
        Integer interval = intervaTot * aggType.getMultiplierFactor();
        if (inputs.containsKey("intervalStep")) {
            interval = (Integer)inputs.get("intervalStep");
        }
        Integer inputStartTime = null;
        String pathFile = null;
        if (inputs.containsKey("startTime")) {
            inputStartTime = (Integer)inputs.get("startTime");
        } else {
            logger.debug("Attention get start Time from file");
            if (inputs.containsKey("pathFile")) {
                String line;
                pathFile = (String)inputs.get("pathFile");
                logger.trace("open file:{}", (Object)pathFile);
                BufferedReader reader = new BufferedReader(new FileReader(pathFile));
                while ((line = reader.readLine()) != null) {
                    String strDate = line = line.trim();
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd");
                    Date d1 = fmt.parse(strDate);
                    Date now = new Date();
                    long millisDiff = now.getTime() - d1.getTime();
                    inputStartTime = (int)(millisDiff / 86400000L);
                    logger.debug("Read Start Time:{}", (Object)d1.toString());
                    logger.debug("Start Time:{}", (Object)inputStartTime);
                }
                reader.close();
            }
        }
        Boolean currentScope = false;
        String scope = null;
        if (inputs.containsKey("currentScope")) {
            currentScope = (Boolean)inputs.get("currentScope");
        }
        if (currentScope.booleanValue()) {
            scope = ScopeProvider.instance.get();
        }
        Constant.user = inputs.containsKey("user") ? (String)inputs.get("user") : "service.aggregatorAccounting";
        if (inputs.containsKey("recovery")) {
            recoveryMode = (Integer)inputs.get("recovery");
        }
        if (inputs.containsKey("backup")) {
            this.backup = (Boolean)inputs.get("backup");
        }
        if (inputs.containsKey("typePersisted")) {
            typePersisted = (Integer)inputs.get("typePersisted");
        }
        switch (typePersisted) {
            case 0: {
                this.persisted = PersistTo.MASTER;
                break;
            }
            case 1: {
                this.persisted = PersistTo.ONE;
                break;
            }
            default: {
                this.persisted = PersistTo.MASTER;
            }
        }
        logger.debug("-Launch with Type:{}, Interval:{}, startTime:{}, Scope:{}, Recovery:{}", new Object[]{aggType.toString(), interval, inputStartTime, scope, recoveryMode});
        logger.debug("persist:{} backup:{}", (Object)this.persisted.toString(), (Object)this.backup);
        if (!this.backup.booleanValue()) {
            logger.warn("Attention backup disabled");
            Thread.sleep(20000L);
        }
        if (inputs.containsKey("intervalStep")) {
            logger.debug("Interval is not considered, aggregate only :{} step", (Object)interval);
        }
        String url = null;
        String password = null;
        ArrayList<String> listBucket = new ArrayList<String>();
        try {
            configuration = new AggregatorPersistenceBackendQueryConfiguration(PersistenceCouchBase.class);
            url = configuration.getProperty("URL");
            password = configuration.getProperty("password");
            if (inputs.containsKey("bucket")) {
                listBucket.add(inputs.get("bucket").toString());
            } else {
                listBucket.add(configuration.getProperty("AggregatedStorageUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedServiceUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedJobUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedPortletUsageRecord"));
                listBucket.add(configuration.getProperty("AggregatedTaskUsageRecord"));
            }
        }
        catch (Exception e) {
            logger.error("launch", (Object)e.getLocalizedMessage());
            throw e;
        }
        CouchbaseCluster cluster = CouchbaseCluster.create(ENV, url);
        RecordUtility.addRecordPackage((Package)PortletUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedPortletUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)JobUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedJobUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)TaskUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedTaskUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)StorageUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedStorageUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
        Date today = new Date();
        Date endScriptTime = new Date();
        if (inputs.containsKey("endScriptTime")) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            endScriptTime = df.parse(today.getMonth() + 1 + "/" + today.getDate() + "/" + (today.getYear() + 1900) + " " + (String)inputs.get("endScriptTime"));
            logger.debug("Script Run until :{}", (Object)endScriptTime);
        }
        do {
            logger.debug("--Start Time Loop:{}" + inputStartTime);
            this.initFolder();
            if (recoveryMode == 2 || recoveryMode == 0) {
                logger.debug("Recovery mode enabled");
                RecoveryRecord.searchFile(cluster, configuration);
            }
            if (recoveryMode == 2) continue;
            for (String bucket : listBucket) {
                logger.trace("OpenBucket:{}", (Object)bucket);
                this.accountingBucket = cluster.openBucket(bucket, password);
                this.elaborateBucket(bucket, scope, inputStartTime, interval, aggType);
            }
            if (inputs.containsKey("pathFile")) {
                FileOutputStream file = new FileOutputStream(pathFile);
                PrintStream output = new PrintStream(file);
                logger.debug("Update pathfile:{} with new start time:{}", (Object)pathFile, (Object)(inputStartTime - intervaTot));
                Date dateNow = new Date();
                Calendar data = Calendar.getInstance();
                data.setTime(dateNow);
                data.add(5, -(inputStartTime - intervaTot));
                SimpleDateFormat format1 = new SimpleDateFormat("yyyy/MM/dd");
                String formatted = format1.format(data.getTime());
                output.println(formatted);
                inputStartTime = inputStartTime - intervaTot;
                today = new Date();
            }
            logger.debug("Complete countInsert{}, countDelete{}", (Object)countInsert, (Object)countDelete);
        } while (today.compareTo(endScriptTime) < 0);
        logger.debug("Plugin Terminated");
    }

    protected void onStop() throws Exception {
        logger.trace("{} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Thread.currentThread().interrupt();
    }

    public void initFolder() {
        Constant.PATH_DIR_BACKUP = System.getProperty("user.home") + "/" + Constant.NAME_DIR_BACKUP;
        Constant.PATH_DIR_BACKUP_INSERT = Constant.PATH_DIR_BACKUP + "/insert";
        Constant.PATH_DIR_BACKUP_DELETE = Constant.PATH_DIR_BACKUP + "/delete";
        File DirRoot = new File(Constant.PATH_DIR_BACKUP);
        if (!DirRoot.exists()) {
            DirRoot.mkdir();
        }
        logger.debug("init folder:{}", (Object)Constant.PATH_DIR_BACKUP);
    }

    protected boolean elaborateBucket(String bucket, String scope, Integer inputStartTime, Integer interval, AggregationType aggType) throws Exception {
        Calendar nowTemp;
        Calendar now;
        SimpleDateFormat format = new SimpleDateFormat(aggType.getDateformat());
        if (inputStartTime == null) {
            now = Calendar.getInstance();
            nowTemp = Calendar.getInstance();
        } else {
            now = Calendar.getInstance();
            nowTemp = Calendar.getInstance();
            switch (aggType.name()) {
                case "YEARLY": {
                    now.add(1, -inputStartTime.intValue());
                    nowTemp.add(1, -inputStartTime.intValue());
                    break;
                }
                case "MONTHLY": {
                    now.add(2, -inputStartTime.intValue());
                    nowTemp.add(2, -inputStartTime.intValue());
                    break;
                }
                case "DAILY": {
                    now.add(5, -inputStartTime.intValue());
                    nowTemp.add(5, -inputStartTime.intValue());
                    break;
                }
                case "HOURLY": {
                    now.add(10, -inputStartTime.intValue());
                    nowTemp.add(10, -inputStartTime.intValue());
                }
            }
        }
        String endAllKeyString = format.format(now.getTime());
        String endKeyString = format.format(now.getTime());
        nowTemp.add(aggType.getCalendarField(), -1 * interval);
        String startAllKeyString = format.format(nowTemp.getTime());
        if (this.backup.booleanValue()) {
            logger.debug("Start Backup");
            WorkSpaceManagement.onSaveBackupFile(this.accountingBucket, bucket, scope, startAllKeyString, endAllKeyString, aggType);
        } else {
            logger.debug("No Backup required");
        }
        ArrayList<JsonDocument> documentElaborate = new ArrayList<JsonDocument>();
        for (int i = 0; i < interval; ++i) {
            now.add(aggType.getCalendarField(), -1);
            String startKeyString = format.format(now.getTime());
            JsonArray startKey = Utility.generateKey(scope, startKeyString);
            JsonArray endKey = Utility.generateKey(scope, endKeyString);
            DesignID designid = DesignID.valueOf(bucket);
            String designDocId = designid.getNameDesign();
            String viewName = "";
            viewName = scope != null ? designid.getNameViewScope() : designid.getNameView();
            ViewQuery query = ViewQuery.from(designDocId, viewName);
            query.startKey(startKey);
            query.endKey(endKey);
            query.reduce(false);
            query.inclusiveEnd(false);
            logger.debug("--{}/{} View Query: startKey:{} - endKey:{} designDocId:{} - viewName:{}", new Object[]{i, interval, startKey, endKey, designDocId, viewName});
            ViewResult viewResult = null;
            try {
                viewResult = this.accountingBucket.query(query);
            }
            catch (Exception e) {
                logger.error("Exception error VIEW", (Object)e.getLocalizedMessage(), (Object)e);
            }
            this.aggregate = new Aggregation();
            documentElaborate.clear();
            logger.debug("Start elaborate row");
            Boolean resultElaborate = false;
            for (ViewRow row : viewResult) {
                resultElaborate = this.elaborateRow(row, documentElaborate);
            }
            logger.debug("End elaborate row");
            String nameFileBackup = "";
            nameFileBackup = scope != null ? scope.replace("/", "") + "-" + startKeyString + "-" + endKeyString : startKeyString + "-" + endKeyString;
            this.reallyFlush(this.aggregate, documentElaborate, nameFileBackup);
            endKeyString = startKeyString;
        }
        return true;
    }

    protected Boolean elaborateRow(ViewRow row, List<JsonDocument> documentElaborate) throws Exception {
        int i = 0;
        JsonDocument documentJson = null;
        try {
            String document = row.value().toString().replace("\":", KEY_VALUE_LINKER).replace("\"", "");
            i = 1;
            Map<String, ? extends Serializable> map = AccountingAggregatorPlugin.getMapFromString(document);
            i = 2;
            String identifier = (String)((JsonObject)row.document().content()).get("id");
            i = 3;
            documentJson = JsonDocument.create(identifier, (JsonObject)row.document().content());
            i = 4;
            AggregatedRecord record = (AggregatedRecord)RecordUtility.getRecord(map);
            i = 5;
            this.aggregate.aggregate(record);
            i = 6;
            documentElaborate.add(documentJson);
            i = 7;
            return true;
        }
        catch (InvalidValueException ex) {
            logger.warn("InvalidValueException - Record is not valid. Anyway, it will be persisted i:{}", (Object)i);
            logger.warn("Runtime Exception ex", (Throwable)ex);
            if (i == 5 && documentJson != null) {
                documentElaborate.add(documentJson);
            }
            return false;
        }
        catch (RuntimeException exr) {
            logger.warn("Runtime Exception -Record is not valid. Anyway, it will be persisted i:{}", (Object)i);
            logger.warn("Runtime Exception exr", (Throwable)exr);
            if (i == 5 && documentJson != null) {
                documentElaborate.add(documentJson);
                logger.debug("Record is elaborate");
            }
            return false;
        }
        catch (Exception e) {
            logger.error("record is not elaborated:" + row.toString() + " but it will be persisted");
            logger.error("error elaborateRow", (Throwable)e);
            logger.error("i:{}", (Object)i);
            if (i == 5 && documentJson != null) {
                documentElaborate.add(documentJson);
                logger.debug("Record is elaborate");
            }
            return false;
        }
    }

    protected static Map<String, ? extends Serializable> getMapFromString(String serializedMap) {
        if (!serializedMap.startsWith(LINE_FREFIX) && !serializedMap.endsWith(LINE_SUFFIX)) {
            return null;
        }
        serializedMap = serializedMap.replace(LINE_FREFIX, "");
        serializedMap = serializedMap.replace(LINE_SUFFIX, "");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = serializedMap.split(KEY_VALUE_PAIR_SEPARATOR);
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            pair.trim();
            String[] keyValue = pair.split(KEY_VALUE_LINKER);
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }

    protected boolean reallyFlush(Aggregation aggregate, List<JsonDocument> docs, String nameFile) throws Exception {
        if (docs.size() != 0) {
            Integer n;
            Object object;
            Integer index = 0;
            boolean succesfulDelete = false;
            logger.trace("Start a delete document:{}", (Object)docs.size());
            List<JsonDocument> notDeleted = docs;
            List<JsonDocument> notInserted = aggregate.reallyFlush();
            nameFile = nameFile + "-" + UUID.randomUUID();
            ManagementFileBackup.getInstance().onCreateStringToFile(notDeleted, "no_aggregated_" + nameFile, false);
            ManagementFileBackup.getInstance().onCreateStringToFile(notInserted, "aggregated_" + nameFile, true);
            ArrayList<JsonDocument> notDeletedTemp = null;
            while (index < Constant.NUM_RETRY && !succesfulDelete) {
                notDeletedTemp = new ArrayList<JsonDocument>();
                for (JsonDocument jsonDocument : notDeleted) {
                    if (index > 0) {
                        logger.trace("delete Start {} pass", (Object)index);
                    }
                    object = countDelete;
                    n = countDelete = Integer.valueOf(countDelete + 1);
                    try {
                        this.accountingBucket.remove(jsonDocument.id(), this.persisted, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.warn("doc:{} not deleted retry:{} for error:{}", new Object[]{jsonDocument.id(), index, e});
                        Thread.sleep(1500L);
                        try {
                            if (!this.accountingBucket.exists(jsonDocument.id())) continue;
                            notDeletedTemp.add(jsonDocument);
                        }
                        catch (Exception ext) {
                            logger.warn("doc:{} not verify for delete because timeout, retry:{}", new Object[]{jsonDocument.id(), index, ext});
                            Thread.sleep(3000L);
                            try {
                                if (!this.accountingBucket.exists(jsonDocument.id())) continue;
                                notDeletedTemp.add(jsonDocument);
                            }
                            catch (Exception ex) {
                                logger.error("doc:{} not delete ({}), problem with exist bucket", new Object[]{jsonDocument.id(), jsonDocument.toString(), ex});
                                logger.error("force insert into list for delete");
                                notDeletedTemp.add(jsonDocument);
                            }
                        }
                    }
                }
                if (notDeletedTemp.isEmpty()) {
                    succesfulDelete = true;
                    continue;
                }
                Integer n2 = index;
                Integer n3 = index = Integer.valueOf(index + 1);
                notDeleted = new ArrayList<JsonDocument>(notDeletedTemp);
                Thread.sleep(1000L);
                logger.trace("First pass no delete all succesfulDelete:{} index:{}", (Object)succesfulDelete, (Object)index);
            }
            if (!succesfulDelete) {
                logger.error("Error Delete record");
            }
            logger.debug("Delete complete:{}, Start a insert aggregated document:{}", (Object)countDelete, (Object)notInserted.size());
            if (succesfulDelete) {
                ManagementFileBackup.getInstance().onDeleteFile("no_aggregated_" + nameFile, false);
                index = 0;
                boolean succesfulInsert = false;
                while (index < Constant.NUM_RETRY && !succesfulInsert) {
                    ArrayList<JsonDocument> arrayList = new ArrayList<JsonDocument>();
                    for (JsonDocument document : notInserted) {
                        if (index > 0) {
                            logger.trace("insert Start {} pass for document:{}", (Object)index, (Object)document.toString());
                        }
                        Serializable ex = countInsert;
                        Integer n4 = countInsert = Integer.valueOf(countInsert + 1);
                        try {
                            ex = this.accountingBucket.upsert(document, this.persisted, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            logger.warn("record:{} not insert retry:{}  for error:{}", new Object[]{document.id(), index, e});
                            Thread.sleep(1500L);
                            try {
                                if (this.accountingBucket.exists(document.id())) continue;
                                arrayList.add(document);
                            }
                            catch (Exception ext) {
                                logger.warn("doc:{} not verify for insert because timeout, retry", (Object)document.id(), (Object)ext);
                                Thread.sleep(3000L);
                                try {
                                    if (this.accountingBucket.exists(document.id())) continue;
                                    arrayList.add(document);
                                }
                                catch (Exception ex2) {
                                    logger.error("doc:{} not insert ({}), problem with exist bucket", new Object[]{document.id(), document.toString(), ex2});
                                    logger.error("force insert into list for insert");
                                    arrayList.add(document);
                                }
                            }
                        }
                    }
                    if (arrayList.isEmpty()) {
                        succesfulInsert = true;
                        continue;
                    }
                    object = index;
                    n = index = Integer.valueOf(index + 1);
                    notInserted = new ArrayList<JsonDocument>(arrayList);
                    Thread.sleep(1000L);
                    logger.trace("First pass no insert all succesfulInsert:{} index:{}", (Object)succesfulInsert, (Object)index);
                }
                if (!succesfulInsert) {
                    logger.error("Error Insert record{}");
                } else {
                    logger.debug("elaborate record aggregate:{} and record not aggregate:{}", (Object)countInsert, (Object)countDelete);
                    ManagementFileBackup.getInstance().onDeleteFile("aggregated_" + nameFile, true);
                }
            }
            logger.trace("Insert complete");
        }
        return true;
    }
}

