/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Dimension;

public class Profiler
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("set")) {
            this.doOptions();
            return 4096;
        }
        this.imp = imp;
        return 1439;
    }

    public void run(ImageProcessor ip) {
        boolean averageHorizontally = Prefs.verticalProfile || IJ.altKeyDown();
        new ProfilePlot(this.imp, averageHorizontally).createWindow();
    }

    public void doOptions() {
        boolean fixedScale;
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        boolean wasFixedScale = fixedScale = ymin != 0.0 || ymax != 0.0;
        GenericDialog gd = new GenericDialog("Profile Plot Options", IJ.getInstance());
        gd.addNumericField("Width (pixels):", PlotWindow.plotWidth, 0);
        gd.addNumericField("Height (pixels):", PlotWindow.plotHeight, 0);
        gd.addNumericField("Minimum Y:", ymin, 2);
        gd.addNumericField("Maximum Y:", ymax, 2);
        gd.addCheckbox("Fixed y-axis scale", fixedScale);
        gd.addCheckbox("Do not save x-values", !PlotWindow.saveXValues);
        gd.addCheckbox("Auto-close", PlotWindow.autoClose);
        gd.addCheckbox("Vertical profile", Prefs.verticalProfile);
        gd.addCheckbox("List values", PlotWindow.listValues);
        gd.addCheckbox("Interpolate line profiles", PlotWindow.interpolate);
        gd.addCheckbox("Draw grid lines", !PlotWindow.noGridLines);
        gd.addCheckbox("Sub-pixel resolution", Prefs.subPixelResolution);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#plot-options");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Dimension screen = IJ.getScreenSize();
        int w = (int)gd.getNextNumber();
        int h = (int)gd.getNextNumber();
        if (w < 100) {
            w = 100;
        }
        if (w > screen.width - 140) {
            w = screen.width - 140;
        }
        if (h < 50) {
            h = 50;
        }
        if (h > screen.height - 300) {
            h = screen.height - 300;
        }
        PlotWindow.plotWidth = w;
        PlotWindow.plotHeight = h;
        ymin = gd.getNextNumber();
        ymax = gd.getNextNumber();
        fixedScale = gd.getNextBoolean();
        PlotWindow.saveXValues = !gd.getNextBoolean();
        PlotWindow.autoClose = gd.getNextBoolean();
        Prefs.verticalProfile = gd.getNextBoolean();
        PlotWindow.listValues = gd.getNextBoolean();
        PlotWindow.interpolate = gd.getNextBoolean();
        PlotWindow.noGridLines = !gd.getNextBoolean();
        Prefs.subPixelResolution = gd.getNextBoolean();
        if (!(fixedScale || wasFixedScale || ymin == 0.0 && ymax == 0.0)) {
            fixedScale = true;
        }
        if (!fixedScale) {
            ymin = 0.0;
            ymax = 0.0;
        } else if (ymin > ymax) {
            double tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        ProfilePlot.setMinAndMax(ymin, ymax);
        IJ.register(Profiler.class);
    }
}

