/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lombok.Lombok;
import lombok.core.ImportList;
import lombok.core.LombokConfiguration;
import lombok.core.LombokImmutableList;
import lombok.core.LombokNode;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.debug.HistogramTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AST<A extends AST<A, L, N>, L extends LombokNode<A, L, N>, N> {
    private L top;
    private final String fileName;
    private final String packageDeclaration;
    private final ImportList imports;
    Map<N, N> identityDetector = new IdentityHashMap<N, N>();
    private Map<N, L> nodeMap = new IdentityHashMap<N, L>();
    private boolean changed = false;
    private static final HistogramTracker histogramTracker = System.getProperty("lombok.timeConfig") == null ? null : new HistogramTracker("lombok.config");
    private static Map<Class<?>, Collection<FieldAccess>> fieldsOfASTClasses = new HashMap();

    protected AST(String fileName, String packageDeclaration, ImportList imports) {
        this.fileName = fileName == null ? "(unknown).java" : fileName;
        this.packageDeclaration = packageDeclaration;
        this.imports = imports;
    }

    public abstract URI getAbsoluteFileLocation();

    public void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setTop(L top) {
        this.top = top;
    }

    public final String getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public final ImportList getImportList() {
        return this.imports;
    }

    protected L putInMap(L node) {
        this.nodeMap.put(((LombokNode)node).get(), node);
        this.identityDetector.put(((LombokNode)node).get(), ((LombokNode)node).get());
        return node;
    }

    protected Map<N, L> getNodeMap() {
        return this.nodeMap;
    }

    protected void clearState() {
        this.identityDetector = new IdentityHashMap<N, N>();
        this.nodeMap = new IdentityHashMap<N, L>();
    }

    protected boolean setAndGetAsHandled(N node) {
        return this.identityDetector.put(node, node) != null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public L top() {
        return this.top;
    }

    public L get(N node) {
        return (L)((LombokNode)this.nodeMap.get(node));
    }

    public int getSourceVersion() {
        return 6;
    }

    public int getLatestJavaSpecSupported() {
        return 6;
    }

    L replaceNewWithExistingOld(Map<N, L> oldNodes, L newNode) {
        LombokNode oldNode = (LombokNode)oldNodes.get(((LombokNode)newNode).get());
        Object targetNode = oldNode == null ? newNode : oldNode;
        ArrayList<LombokNode> children = new ArrayList<LombokNode>();
        for (LombokNode child : ((LombokNode)newNode).children) {
            LombokNode oldChild = this.replaceNewWithExistingOld(oldNodes, child);
            children.add(oldChild);
            oldChild.parent = targetNode;
        }
        ((LombokNode)targetNode).children = LombokImmutableList.copyOf(children);
        return targetNode;
    }

    protected abstract L buildTree(N var1, Kind var2);

    protected Collection<FieldAccess> fieldsOf(Class<?> c) {
        Collection<FieldAccess> fields = fieldsOfASTClasses.get(c);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<FieldAccess>();
        this.getFields(c, fields);
        fieldsOfASTClasses.put(c, fields);
        return fields;
    }

    private void getFields(Class<?> c, Collection<FieldAccess> fields) {
        if (c == Object.class || c == null) {
            return;
        }
        for (Field f : c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> t = f.getType();
            int dim = 0;
            if (t.isArray()) {
                while (t.isArray()) {
                    ++dim;
                    t = t.getComponentType();
                }
            } else {
                while (Collection.class.isAssignableFrom(t)) {
                    ++dim;
                    t = this.getComponentType(f.getGenericType());
                }
            }
            if (!this.shouldDrill(c, t, f.getName())) continue;
            f.setAccessible(true);
            fields.add(new FieldAccess(f, dim));
        }
        this.getFields(c.getSuperclass(), fields);
    }

    private Class<?> getComponentType(Type type) {
        if (type instanceof ParameterizedType) {
            Type component = ((ParameterizedType)type).getActualTypeArguments()[0];
            return component instanceof Class ? (Class)component : Object.class;
        }
        return Object.class;
    }

    protected abstract Collection<Class<? extends N>> getStatementTypes();

    protected boolean shouldDrill(Class<?> parentType, Class<?> childType, String fieldName) {
        for (Class<N> statementType : this.getStatementTypes()) {
            if (!statementType.isAssignableFrom(childType)) continue;
            return true;
        }
        return false;
    }

    protected Collection<L> buildWithField(Class<L> nodeType, N statement, FieldAccess fa) {
        ArrayList list = new ArrayList();
        this.buildWithField0(nodeType, statement, fa, list);
        return list;
    }

    protected boolean replaceStatementInNode(N statement, N oldN, N newN) {
        for (FieldAccess fa : this.fieldsOf(statement.getClass())) {
            if (!this.replaceStatementInField(fa, statement, oldN, newN)) continue;
            return true;
        }
        return false;
    }

    private boolean replaceStatementInField(FieldAccess fa, N statement, N oldN, N newN) {
        try {
            Object o = fa.field.get(statement);
            if (o == null) {
                return false;
            }
            if (o == oldN) {
                fa.field.set(statement, newN);
                return true;
            }
            if (fa.dim > 0) {
                if (o.getClass().isArray()) {
                    return this.replaceStatementInArray(o, oldN, newN);
                }
                if (Collection.class.isInstance(o)) {
                    return this.replaceStatementInCollection(fa.field, statement, new ArrayList(), (Collection)o, oldN, newN);
                }
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw Lombok.sneakyThrow(e);
        }
    }

    private boolean replaceStatementInCollection(Field field, Object fieldRef, List<Collection<?>> chain, Collection<?> collection, N oldN, N newN) throws IllegalAccessException {
        if (collection == null) {
            return false;
        }
        int idx = -1;
        for (Object o : collection) {
            ++idx;
            if (o == null) continue;
            if (Collection.class.isInstance(o)) {
                Collection newC = (Collection)o;
                ArrayList newChain = new ArrayList(chain);
                newChain.add(newC);
                if (this.replaceStatementInCollection(field, fieldRef, newChain, newC, oldN, newN)) {
                    return true;
                }
            }
            if (o != oldN) continue;
            this.setElementInASTCollection(field, fieldRef, chain, collection, idx, newN);
            return true;
        }
        return false;
    }

    protected void setElementInASTCollection(Field field, Object fieldRef, List<Collection<?>> chain, Collection<?> collection, int idx, N newN) throws IllegalAccessException {
        if (collection instanceof List) {
            ((List)collection).set(idx, newN);
        }
    }

    private boolean replaceStatementInArray(Object array, N oldN, N newN) {
        if (array == null) {
            return false;
        }
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object o = Array.get(array, i);
            if (o == null) continue;
            if (o.getClass().isArray()) {
                if (!this.replaceStatementInArray(o, oldN, newN)) continue;
                return true;
            }
            if (o != oldN) continue;
            Array.set(array, i, newN);
            return true;
        }
        return false;
    }

    private void buildWithField0(Class<L> nodeType, N child, FieldAccess fa, Collection<L> list) {
        try {
            Object o = fa.field.get(child);
            if (o == null) {
                return;
            }
            if (fa.dim == 0) {
                L node = this.buildTree(o, Kind.STATEMENT);
                if (node != null) {
                    list.add(nodeType.cast(node));
                }
            } else if (o.getClass().isArray()) {
                this.buildWithArray(nodeType, o, list, fa.dim);
            } else if (Collection.class.isInstance(o)) {
                this.buildWithCollection(nodeType, o, list, fa.dim);
            }
        }
        catch (IllegalAccessException e) {
            throw Lombok.sneakyThrow(e);
        }
    }

    private void buildWithArray(Class<L> nodeType, Object array, Collection<L> list, int dim) {
        if (dim == 1) {
            for (Object v : (Object[])array) {
                L node;
                if (v == null || (node = this.buildTree(v, Kind.STATEMENT)) == null) continue;
                list.add(nodeType.cast(node));
            }
        } else {
            for (Object v : (Object[])array) {
                if (v == null) {
                    return;
                }
                this.buildWithArray(nodeType, v, list, dim - 1);
            }
        }
    }

    private void buildWithCollection(Class<L> nodeType, Object collection, Collection<L> list, int dim) {
        if (dim == 1) {
            for (Object v : (Collection)collection) {
                L node;
                if (v == null || (node = this.buildTree(v, Kind.STATEMENT)) == null) continue;
                list.add(nodeType.cast(node));
            }
        } else {
            for (Object v : (Collection)collection) {
                this.buildWithCollection(nodeType, v, list, dim - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readConfiguration(ConfigurationKey<T> key) {
        long start = System.currentTimeMillis();
        try {
            T t = LombokConfiguration.read(key, this);
            return t;
        }
        finally {
            if (histogramTracker != null) {
                histogramTracker.report(start);
            }
        }
    }

    protected static class FieldAccess {
        public final Field field;
        public final int dim;

        FieldAccess(Field field, int dim) {
            this.field = field;
            this.dim = dim;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        COMPILATION_UNIT,
        TYPE,
        FIELD,
        INITIALIZER,
        METHOD,
        ANNOTATION,
        ARGUMENT,
        LOCAL,
        STATEMENT;

    }
}

