/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import lombok.AccessLevel;
import lombok.ConfigurationKeys;
import lombok.Value;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.core.handlers.HandlerUtil;
import lombok.experimental.Builder;
import lombok.experimental.NonFinal;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.HandleConstructor;
import lombok.javac.handlers.HandleSetter;
import lombok.javac.handlers.HandleToString;
import lombok.javac.handlers.JavacHandlerUtil;

@HandlerPriority(value=-1024)
public class HandleBuilder
extends JavacAnnotationHandler<Builder> {
    @Override
    public void handle(AnnotationValues<Builder> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JCTree.JCMethodDecl jCMethodDecl;
        JCTree.JCMethodDecl jCMethodDecl2;
        JCTree.JCMethodDecl jCMethodDecl3;
        JCTree.JCMethodDecl jCMethodDecl4;
        JavacNode builderType;
        Name nameOfStaticBuilderMethod;
        JCTree.JCExpression returnType2;
        JCTree.JCClassDecl td;
        JavacNode tdParent;
        JCTree.JCMethodDecl fillParametersFrom;
        HandlerUtil.handleExperimentalFlagUsage(annotationNode, ConfigurationKeys.BUILDER_FLAG_USAGE, "@Builder");
        Builder builderInstance = annotation.getInstance();
        String builderMethodName = builderInstance.builderMethodName();
        String buildMethodName = builderInstance.buildMethodName();
        String builderClassName = builderInstance.builderClassName();
        if (builderMethodName == null) {
            builderMethodName = "builder";
        }
        if (buildMethodName == null) {
            buildMethodName = "build";
        }
        if (builderClassName == null) {
            builderClassName = "";
        }
        if (!HandlerUtil.checkName("builderMethodName", builderMethodName, annotationNode)) {
            return;
        }
        if (!HandlerUtil.checkName("buildMethodName", buildMethodName, annotationNode)) {
            return;
        }
        if (!builderClassName.isEmpty() && !HandlerUtil.checkName("builderClassName", builderClassName, annotationNode)) {
            return;
        }
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Builder.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.experimental.Builder");
        JavacNode parent = (JavacNode)annotationNode.up();
        ArrayList<JCTree.JCExpression> typesOfParameters = new ArrayList<JCTree.JCExpression>();
        ArrayList<Name> namesOfParameters = new ArrayList<Name>();
        List<Object> typeParams = List.nil();
        List<JCTree.JCExpression> thrownExceptions = List.nil();
        JCTree.JCMethodDecl jCMethodDecl5 = fillParametersFrom = parent.get() instanceof JCTree.JCMethodDecl ? (JCTree.JCMethodDecl)parent.get() : null;
        if (parent.get() instanceof JCTree.JCClassDecl) {
            tdParent = parent;
            td = (JCTree.JCClassDecl)tdParent.get();
            ListBuffer<JavacNode> allFields = new ListBuffer<JavacNode>();
            boolean valuePresent = JavacHandlerUtil.hasAnnotation(Value.class, parent) || JavacHandlerUtil.hasAnnotation(lombok.experimental.Value.class, parent);
            for (JavacNode fieldNode : HandleConstructor.findAllFields(tdParent)) {
                JCTree.JCVariableDecl fd = (JCTree.JCVariableDecl)fieldNode.get();
                if (fd.init != null && valuePresent && !JavacHandlerUtil.hasAnnotation(NonFinal.class, fieldNode)) continue;
                namesOfParameters.add(JavacHandlerUtil.removePrefixFromField(fieldNode));
                typesOfParameters.add(fd.vartype);
                allFields.append(fieldNode);
            }
            new HandleConstructor().generateConstructor(tdParent, AccessLevel.PACKAGE, List.<JCTree.JCAnnotation>nil(), allFields.toList(), null, HandleConstructor.SkipIfConstructorExists.I_AM_BUILDER, null, annotationNode);
            returnType2 = JavacHandlerUtil.namePlusTypeParamsToTypeReference(tdParent.getTreeMaker(), td.name, td.typarams);
            typeParams = td.typarams;
            thrownExceptions = List.nil();
            nameOfStaticBuilderMethod = null;
            if (builderClassName.isEmpty()) {
                builderClassName = td.name.toString() + "Builder";
            }
        } else if (fillParametersFrom != null && fillParametersFrom.getName().toString().equals("<init>")) {
            if (!fillParametersFrom.typarams.isEmpty()) {
                annotationNode.addError("@Builder is not supported on constructors with constructor type parameters.");
                return;
            }
            tdParent = (JavacNode)parent.up();
            td = (JCTree.JCClassDecl)tdParent.get();
            returnType2 = JavacHandlerUtil.namePlusTypeParamsToTypeReference(tdParent.getTreeMaker(), td.name, td.typarams);
            typeParams = td.typarams;
            thrownExceptions = fillParametersFrom.thrown;
            nameOfStaticBuilderMethod = null;
            if (builderClassName.isEmpty()) {
                builderClassName = td.name.toString() + "Builder";
            }
        } else if (fillParametersFrom != null) {
            tdParent = (JavacNode)parent.up();
            td = (JCTree.JCClassDecl)tdParent.get();
            if ((fillParametersFrom.mods.flags & 8L) == 0L) {
                annotationNode.addError("@Builder is only supported on types, constructors, and static methods.");
                return;
            }
            JCTree.JCExpression returnType22 = fillParametersFrom.restype;
            typeParams = fillParametersFrom.typarams;
            thrownExceptions = fillParametersFrom.thrown;
            nameOfStaticBuilderMethod = fillParametersFrom.name;
            if (builderClassName.isEmpty()) {
                if (returnType22 instanceof JCTree.JCTypeApply) {
                    returnType22 = ((JCTree.JCTypeApply)returnType22).clazz;
                }
                if (returnType22 instanceof JCTree.JCFieldAccess) {
                    builderClassName = ((JCTree.JCFieldAccess)returnType22).name.toString() + "Builder";
                } else if (returnType22 instanceof JCTree.JCIdent) {
                    Name n = ((JCTree.JCIdent)returnType22).name;
                    for (JCTree.JCTypeParameter jCTypeParameter : typeParams) {
                        if (!jCTypeParameter.name.equals(n)) continue;
                        annotationNode.addError("@Builder requires specifying 'builderClassName' if used on methods with a type parameter as return type.");
                        return;
                    }
                    builderClassName = n.toString() + "Builder";
                } else if (returnType22 instanceof JCTree.JCPrimitiveTypeTree) {
                    builderClassName = returnType22.toString() + "Builder";
                    if (Character.isLowerCase(builderClassName.charAt(0))) {
                        builderClassName = Character.toTitleCase(builderClassName.charAt(0)) + builderClassName.substring(1);
                    }
                } else {
                    System.err.println("Lombok bug ID#20140614-1651: javac HandleBuilder: return type to name conversion failed: " + returnType22.getClass());
                    builderClassName = td.name.toString() + "Builder";
                }
            }
        } else {
            annotationNode.addError("@Builder is only supported on types, constructors, and static methods.");
            return;
        }
        if (fillParametersFrom != null) {
            for (JCTree.JCVariableDecl param : fillParametersFrom.params) {
                namesOfParameters.add(param.name);
                typesOfParameters.add(param.vartype);
            }
        }
        if ((builderType = this.findInnerClass(tdParent, builderClassName)) == null) {
            builderType = this.makeBuilderClass(tdParent, builderClassName, typeParams, ast);
        } else {
            JavacHandlerUtil.sanityCheckForMethodGeneratingAnnotationsOnBuilderClass(builderType, annotationNode);
        }
        java.util.List<JavacNode> fieldNodes = this.addFieldsToBuilder(builderType, namesOfParameters, typesOfParameters, ast);
        ArrayList<JCTree.JCMethodDecl> newMethods = new ArrayList<JCTree.JCMethodDecl>();
        for (JavacNode fieldNode : fieldNodes) {
            JCTree.JCMethodDecl newMethod = this.makeSetterMethodForBuilder(builderType, fieldNode, annotationNode, builderInstance.fluent(), builderInstance.chain());
            if (newMethod == null) continue;
            newMethods.add(newMethod);
        }
        if (JavacHandlerUtil.constructorExists(builderType) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS && (jCMethodDecl4 = HandleConstructor.createConstructor(AccessLevel.PACKAGE, List.<JCTree.JCAnnotation>nil(), builderType, List.<JavacNode>nil(), null, annotationNode)) != null) {
            JavacHandlerUtil.injectMethod(builderType, jCMethodDecl4);
        }
        for (JCTree.JCMethodDecl newMethod : newMethods) {
            JavacHandlerUtil.injectMethod(builderType, newMethod);
        }
        if (JavacHandlerUtil.methodExists(buildMethodName, builderType, -1) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS && (jCMethodDecl3 = this.generateBuildMethod(buildMethodName, nameOfStaticBuilderMethod, returnType2, namesOfParameters, builderType, thrownExceptions)) != null) {
            JavacHandlerUtil.injectMethod(builderType, jCMethodDecl3);
        }
        if (JavacHandlerUtil.methodExists("toString", builderType, 0) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS && (jCMethodDecl2 = HandleToString.createToString(builderType, fieldNodes, true, false, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD, ast)) != null) {
            JavacHandlerUtil.injectMethod(builderType, jCMethodDecl2);
        }
        if (JavacHandlerUtil.methodExists(builderMethodName, tdParent, -1) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS && (jCMethodDecl = this.generateBuilderMethod(builderMethodName, builderClassName, tdParent, typeParams)) != null) {
            JavacHandlerUtil.injectMethod(tdParent, jCMethodDecl);
        }
    }

    public JCTree.JCMethodDecl generateBuildMethod(String name, Name staticName, JCTree.JCExpression returnType2, java.util.List<Name> fieldNames, JavacNode type, List<JCTree.JCExpression> thrownExceptions) {
        JCTree.JCStatement statement;
        JavacTreeMaker maker = type.getTreeMaker();
        ListBuffer<JCTree.JCIdent> args = new ListBuffer<JCTree.JCIdent>();
        for (Name n : fieldNames) {
            args.append(maker.Ident(n));
        }
        if (staticName == null) {
            JCTree.JCNewClass call = maker.NewClass(null, List.<JCTree.JCExpression>nil(), returnType2, args.toList(), null);
            statement = maker.Return(call);
        } else {
            ListBuffer<JCTree.JCIdent> typeParams = new ListBuffer<JCTree.JCIdent>();
            for (JCTree.JCTypeParameter tp : ((JCTree.JCClassDecl)type.get()).typarams) {
                typeParams.append(maker.Ident(tp.name));
            }
            JCTree.JCFieldAccess fn = maker.Select(maker.Ident(((JCTree.JCClassDecl)((JavacNode)type.up()).get()).name), staticName);
            JCTree.JCMethodInvocation call = maker.Apply(typeParams.toList(), fn, args.toList());
            statement = returnType2 instanceof JCTree.JCPrimitiveTypeTree && Javac.CTC_VOID.equals(JavacTreeMaker.TypeTag.typeTag(returnType2)) ? maker.Exec(call) : maker.Return(call);
        }
        JCTree.JCBlock body = maker.Block(0L, List.of(statement));
        return maker.MethodDef(maker.Modifiers(1L), type.toName(name), returnType2, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), thrownExceptions, body, null);
    }

    public JCTree.JCMethodDecl generateBuilderMethod(String builderMethodName, String builderClassName, JavacNode type, List<JCTree.JCTypeParameter> typeParams) {
        JavacTreeMaker maker = type.getTreeMaker();
        ListBuffer<JCTree.JCIdent> typeArgs = new ListBuffer<JCTree.JCIdent>();
        for (JCTree.JCTypeParameter typeParam : typeParams) {
            typeArgs.append(maker.Ident(typeParam.name));
        }
        JCTree.JCNewClass call = maker.NewClass(null, List.<JCTree.JCExpression>nil(), JavacHandlerUtil.namePlusTypeParamsToTypeReference(maker, type.toName(builderClassName), typeParams), List.<JCTree.JCExpression>nil(), null);
        JCTree.JCReturn statement = maker.Return(call);
        JCTree.JCBlock body = maker.Block(0L, List.of(statement));
        return maker.MethodDef(maker.Modifiers(9L), type.toName(builderMethodName), JavacHandlerUtil.namePlusTypeParamsToTypeReference(maker, type.toName(builderClassName), typeParams), JavacHandlerUtil.copyTypeParams(maker, typeParams), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), body, null);
    }

    public java.util.List<JavacNode> addFieldsToBuilder(JavacNode builderType, java.util.List<Name> namesOfParameters, java.util.List<JCTree.JCExpression> typesOfParameters, JCTree source) {
        int len = namesOfParameters.size();
        ArrayList<JavacNode> existing = new ArrayList<JavacNode>();
        for (JavacNode child : builderType.down()) {
            if (child.getKind() != AST.Kind.FIELD) continue;
            existing.add(child);
        }
        ArrayList<JavacNode> out = new ArrayList<JavacNode>();
        block1: for (int i = len - 1; i >= 0; --i) {
            Name name = namesOfParameters.get(i);
            for (JavacNode exists : existing) {
                Name n = ((JCTree.JCVariableDecl)exists.get()).name;
                if (!n.equals(name)) continue;
                out.add(exists);
                continue block1;
            }
            JavacTreeMaker maker = builderType.getTreeMaker();
            JCTree.JCModifiers mods = maker.Modifiers(2L);
            JCTree.JCVariableDecl newField = maker.VarDef(mods, name, JavacHandlerUtil.cloneType(maker, typesOfParameters.get(i), source, builderType.getContext()), null);
            out.add(JavacHandlerUtil.injectField(builderType, newField));
        }
        Collections.reverse(out);
        return out;
    }

    public JCTree.JCMethodDecl makeSetterMethodForBuilder(JavacNode builderType, JavacNode fieldNode, JavacNode source, boolean fluent, boolean chain) {
        Name fieldName = ((JCTree.JCVariableDecl)fieldNode.get()).name;
        for (JavacNode child : builderType.down()) {
            Name existingName;
            if (child.getKind() != AST.Kind.METHOD || !(existingName = ((JCTree.JCMethodDecl)child.get()).name).equals(fieldName)) continue;
            return null;
        }
        boolean isBoolean = JavacHandlerUtil.isBoolean(fieldNode);
        String setterName = fluent ? fieldNode.getName() : HandlerUtil.toSetterName(builderType.getAst(), null, fieldNode.getName(), isBoolean);
        JavacTreeMaker maker = builderType.getTreeMaker();
        return HandleSetter.createSetter(1L, fieldNode, maker, setterName, chain, source, List.<JCTree.JCAnnotation>nil(), List.<JCTree.JCAnnotation>nil());
    }

    public JavacNode findInnerClass(JavacNode parent, String name) {
        for (JavacNode child : parent.down()) {
            if (child.getKind() != AST.Kind.TYPE) continue;
            JCTree.JCClassDecl td = (JCTree.JCClassDecl)child.get();
            if (!td.name.contentEquals(name)) continue;
            return child;
        }
        return null;
    }

    public JavacNode makeBuilderClass(JavacNode tdParent, String builderClassName, List<JCTree.JCTypeParameter> typeParams, JCTree.JCAnnotation ast) {
        JavacTreeMaker maker = tdParent.getTreeMaker();
        JCTree.JCModifiers mods = maker.Modifiers(9L);
        JCTree.JCClassDecl builder = maker.ClassDef(mods, tdParent.toName(builderClassName), JavacHandlerUtil.copyTypeParams(maker, typeParams), null, List.<JCTree.JCExpression>nil(), List.<JCTree>nil());
        return JavacHandlerUtil.injectType(tdParent, builder);
    }
}

