/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public final class IOUtils {
    private IOUtils() {
    }

    public static int readFully(InputStream in, byte[] buffer, int off, int max) throws IOException {
        int l;
        int result = 0;
        for (int len = Math.min(max, buffer.length); len > 0 && (l = in.read(buffer, off, len)) >= 0; len -= l) {
            result += l;
            off += l;
        }
        return result;
    }

    public static void skipFully(InputStream in, long skip) throws IOException {
        while (skip > 0L) {
            long skipped = in.skip(skip);
            if (skipped <= 0L) {
                throw new EOFException();
            }
            skip -= skipped;
        }
    }

    public static void writeString(OutputStream out, String s) throws IOException {
        IOUtils.writeBytes(out, s.getBytes("UTF-8"));
    }

    public static String readString(InputStream in) throws IOException {
        return new String(IOUtils.readBytes(in), "UTF-8");
    }

    public static void writeBytes(OutputStream out, byte[] data) throws IOException {
        IOUtils.writeVarInt(out, data.length);
        out.write(data);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int l;
        int len = IOUtils.readVarInt(in);
        byte[] data = new byte[len];
        for (int pos = 0; pos < len; pos += l) {
            l = in.read(data, pos, data.length - pos);
            if (l >= 0) continue;
            throw new EOFException();
        }
        return data;
    }

    public static void writeVarInt(OutputStream out, int x) throws IOException {
        while ((x & 0xFFFFFF80) != 0) {
            out.write(x & 0x7F | 0x80);
            x >>>= 7;
        }
        out.write(x);
    }

    public static int readVarInt(InputStream in) throws IOException {
        int x = in.read();
        if (x >= 0) {
            return x;
        }
        x &= 0x7F;
        int s = 7;
        while (true) {
            int b;
            if ((b = in.read()) < 0) {
                throw new EOFException();
            }
            b = (byte)b;
            x |= (b & 0x7F) << s;
            if (b >= 0) {
                return x;
            }
            s += 7;
        }
    }

    public static void writeVarLong(OutputStream out, long x) throws IOException {
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((byte)(x & 0x7FL | 0x80L));
            x >>>= 7;
        }
        out.write((byte)x);
    }

    public static void writeLong(OutputStream out, long x) throws IOException {
        IOUtils.writeInt(out, (int)(x >>> 32));
        IOUtils.writeInt(out, (int)x);
    }

    public static long readLong(InputStream in) throws IOException {
        return ((long)IOUtils.readInt(in) << 32) + ((long)IOUtils.readInt(in) & 0xFFFFFFFFL);
    }

    public static void writeInt(OutputStream out, int x) throws IOException {
        out.write((byte)(x >> 24));
        out.write((byte)(x >> 16));
        out.write((byte)(x >> 8));
        out.write((byte)x);
    }

    public static int readInt(InputStream in) throws IOException {
        return ((in.read() & 0xFF) << 24) + ((in.read() & 0xFF) << 16) + ((in.read() & 0xFF) << 8) + (in.read() & 0xFF);
    }

    public static long readVarLong(InputStream in) throws IOException {
        long x = (byte)in.read();
        if (x >= 0L) {
            return x;
        }
        x &= 0x7FL;
        int s = 7;
        while (true) {
            long b;
            if ((b = (long)in.read()) < 0L) {
                throw new EOFException();
            }
            b = (byte)b;
            x |= (b & 0x7FL) << s;
            if (b >= 0L) {
                return x;
            }
            s += 7;
        }
    }

    public static int nextPowerOf2(int x) {
        long i;
        for (i = 1L; i < (long)x && i < 0x3FFFFFFFL; i += i) {
        }
        return (int)i;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

