/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SegmentNodeBuilder
extends MemoryNodeBuilder {
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    private final SegmentWriter writer;
    private long updateCount = 0L;

    SegmentNodeBuilder(SegmentNodeState base) {
        super(base);
        this.writer = base.getRecordId().getSegmentId().getTracker().getWriter();
    }

    @Override
    protected void updated() {
        ++this.updateCount;
        if (this.updateCount > (long)UPDATE_LIMIT) {
            this.getNodeState();
        }
    }

    @Override
    public SegmentNodeState getBaseState() {
        return (SegmentNodeState)super.getBaseState();
    }

    @Override
    public SegmentNodeState getNodeState() {
        SegmentNodeState sstate;
        NodeState state = super.getNodeState();
        if (state != (sstate = this.writer.writeNode(state))) {
            this.set(sstate);
            this.updateCount = 0L;
        }
        return sstate;
    }
}

