/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;

public class ColumnImpl
extends AstElement {
    private final String selectorName;
    private final String propertyName;
    private final String columnName;
    private SelectorImpl selector;

    public ColumnImpl(String selectorName, String propertyName, String columnName) {
        this.selectorName = Preconditions.checkNotNull(selectorName);
        this.propertyName = Preconditions.checkNotNull(propertyName);
        this.columnName = Preconditions.checkNotNull(columnName);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.selectorName) + '.' + this.quote(this.propertyName) + " as " + this.quote(this.columnName);
    }

    public PropertyValue currentProperty() {
        return this.selector.currentProperty(this.propertyName);
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    public SelectorImpl getSelector() {
        return this.selector;
    }
}

