/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;

final class UserContext
implements Context,
UserConstants {
    private static final Context INSTANCE = new UserContext();

    private UserContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(Tree parent, PropertyState property) {
        String ntName = TreeUtil.getPrimaryTypeName(parent);
        if ("rep:User".equals(ntName)) {
            return USER_PROPERTY_NAMES.contains(property.getName());
        }
        if ("rep:Group".equals(ntName)) {
            return GROUP_PROPERTY_NAMES.contains(property.getName());
        }
        return "rep:Members".equals(ntName);
    }

    @Override
    public boolean definesContextRoot(@Nonnull Tree tree) {
        return this.definesTree(tree);
    }

    @Override
    public boolean definesTree(Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName(tree);
        return "rep:Group".equals(ntName) || "rep:User".equals(ntName) || "rep:Members".equals(ntName);
    }

    @Override
    public boolean definesLocation(TreeLocation location) {
        Tree tree = location.getTree();
        if (tree != null && location.exists()) {
            PropertyState p = location.getProperty();
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        String path = location.getPath();
        String name = Text.getName(path);
        return USER_PROPERTY_NAMES.contains(name) || GROUP_PROPERTY_NAMES.contains(name) || path.contains("rep:members");
    }
}

