/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class CompositeAuthorizationConfiguration
extends CompositeConfiguration<AuthorizationConfiguration>
implements AuthorizationConfiguration {
    public CompositeAuthorizationConfiguration(@Nonnull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.authorization", securityProvider);
    }

    @Override
    @Nonnull
    public AccessControlManager getAccessControlManager(final @Nonnull Root root, final @Nonnull NamePathMapper namePathMapper) {
        List<AccessControlManager> mgrs = Lists.transform(this.getConfigurations(), new Function<AuthorizationConfiguration, AccessControlManager>(){

            @Override
            public AccessControlManager apply(AuthorizationConfiguration authorizationConfiguration) {
                return authorizationConfiguration.getAccessControlManager(root, namePathMapper);
            }
        });
        return new CompositeAcMgr(root, namePathMapper, this.getSecurityProvider(), mgrs);
    }

    @Override
    @Nonnull
    public RestrictionProvider getRestrictionProvider() {
        return CompositeRestrictionProvider.newInstance(Lists.transform(this.getConfigurations(), new Function<AuthorizationConfiguration, RestrictionProvider>(){

            @Override
            public RestrictionProvider apply(AuthorizationConfiguration authorizationConfiguration) {
                return authorizationConfiguration.getRestrictionProvider();
            }
        }));
    }

    @Override
    @Nonnull
    public PermissionProvider getPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals) {
        throw new UnsupportedOperationException("not yet implemented (OAK-1268)");
    }

    private static class CompositeAcMgr
    extends AbstractAccessControlManager {
        private final List<AccessControlManager> acMgrs;

        private CompositeAcMgr(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider, @Nonnull List<AccessControlManager> acMgrs) {
            super(root, namePathMapper, securityProvider);
            this.acMgrs = acMgrs;
        }

        @Override
        public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
            ImmutableList.Builder privs = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                privs.add(acMgr.getSupportedPrivileges(absPath));
            }
            ImmutableCollection l = privs.build();
            return l.toArray(new Privilege[l.size()]);
        }

        @Override
        public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
            ImmutableList.Builder policies = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                policies.add(acMgr.getPolicies(absPath));
            }
            ImmutableCollection l = policies.build();
            return l.toArray(new AccessControlPolicy[l.size()]);
        }

        @Override
        public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
            ImmutableList.Builder privs = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                privs.add(acMgr.getEffectivePolicies(absPath));
            }
            ImmutableCollection l = privs.build();
            return l.toArray(new AccessControlPolicy[l.size()]);
        }

        @Override
        public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
            ArrayList<AccessControlPolicyIterator> l = Lists.newArrayList();
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof PolicyOwner)) continue;
                l.add(acMgr.getApplicablePolicies(absPath));
            }
            return new AccessControlPolicyIteratorAdapter(Iterators.concat(l.toArray(new AccessControlPolicyIterator[l.size()])));
        }

        @Override
        public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)((Object)acMgr)).defines(absPath, policy)) continue;
                acMgr.setPolicy(absPath, policy);
                return;
            }
            throw new AccessControlException("Cannot set access control policy " + policy + "; no PolicyOwner found.");
        }

        @Override
        public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)((Object)acMgr)).defines(absPath, policy)) continue;
                acMgr.removePolicy(absPath, policy);
                return;
            }
            throw new AccessControlException("Cannot remove access control policy " + policy + "; no PolicyOwner found.");
        }

        @Override
        public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws RepositoryException {
            ImmutableList.Builder policies = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof JackrabbitAccessControlManager) || !(acMgr instanceof PolicyOwner)) continue;
                policies.add(((JackrabbitAccessControlManager)acMgr).getApplicablePolicies(principal));
            }
            ImmutableCollection l = policies.build();
            return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
        }

        @Override
        public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws RepositoryException {
            ImmutableList.Builder privs = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
                privs.add(((JackrabbitAccessControlManager)acMgr).getPolicies(principal));
            }
            ImmutableCollection l = privs.build();
            return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
        }

        @Override
        public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws RepositoryException {
            ImmutableList.Builder privs = ImmutableList.builder();
            for (AccessControlManager acMgr : this.acMgrs) {
                if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
                privs.add(((JackrabbitAccessControlManager)acMgr).getEffectivePolicies(principals));
            }
            ImmutableCollection l = privs.build();
            return l.toArray(new AccessControlPolicy[l.size()]);
        }
    }
}

