/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class ImmutableACL
extends AbstractAccessControlList {
    private final List<JackrabbitAccessControlEntry> entries;
    private final RestrictionProvider restrictionProvider;
    private int hashCode;

    public ImmutableACL(@Nullable String oakPath, @Nonnull List<? extends JackrabbitAccessControlEntry> entries, @Nonnull RestrictionProvider restrictionProvider, @Nonnull NamePathMapper namePathMapper) {
        super(oakPath, namePathMapper);
        this.entries = ImmutableList.copyOf(entries);
        this.restrictionProvider = restrictionProvider;
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicies in order to obtain an modifiable ACL.");
    }

    @Override
    public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws AccessControlException {
        throw new AccessControlException("Immutable ACL. Use AccessControlManager#getPolicy or #getApplicablePolicy in order to obtain a modifiable ACL.");
    }

    public List<JackrabbitAccessControlEntry> getEntries() {
        return this.entries;
    }

    @Override
    public RestrictionProvider getRestrictionProvider() {
        return this.restrictionProvider;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode(this.getOakPath(), this.entries);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableACL) {
            ImmutableACL other = (ImmutableACL)obj;
            return Objects.equal(this.getOakPath(), other.getOakPath()) && this.entries.equals(other.entries);
        }
        return false;
    }
}

