/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.api.jmx.QueryStatManagerMBean;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.jmx.RepositoryStatsMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.RepositoryStats;
import org.apache.jackrabbit.oak.stats.TimeSeriesMax;
import org.apache.jackrabbit.stats.QueryStatImpl;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;
import org.apache.jackrabbit.stats.jmx.QueryStatManager;

public class StatisticManager {
    private final QueryStatImpl queryStat = new QueryStatImpl();
    private final RepositoryStatisticsImpl repoStats;
    private final TimeSeriesMax maxQueueLength;
    private final CompositeRegistration registration;

    public StatisticManager(Whiteboard whiteboard, ScheduledExecutorService executor) {
        this.queryStat.setEnabled(true);
        this.repoStats = new RepositoryStatisticsImpl(executor);
        this.maxQueueLength = new TimeSeriesMax(executor);
        this.registration = new CompositeRegistration(WhiteboardUtils.registerMBean(whiteboard, QueryStatManagerMBean.class, new QueryStatManager(this.queryStat), "QueryStat", "Oak Query Statistics"), WhiteboardUtils.registerMBean(whiteboard, RepositoryStatsMBean.class, new RepositoryStats(this.repoStats, this.maxQueueLength), "RepositoryStats", "Oak Repository Statistics"));
    }

    public void logQueryEvaluationTime(String language, String statement, long millis) {
        this.queryStat.logQuery(language, statement, millis);
    }

    public AtomicLong getCounter(RepositoryStatistics.Type type) {
        return this.repoStats.getCounter(type);
    }

    public TimeSeriesMax maxQueLengthRecorder() {
        return this.maxQueueLength;
    }

    public void dispose() {
        this.registration.unregister();
    }
}

