/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.recovery;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.configuration.Constant;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceBackendQueryConfiguration;
import org.gcube.accounting.aggregator.plugin.AccountingAggregatorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryRecord {
    private static Logger logger = LoggerFactory.getLogger(AccountingAggregatorPlugin.class);
    protected static Cluster cluster = null;
    protected static Bucket bucketStorage;
    protected static String bucketNameStorage;
    protected static Bucket bucketService;
    protected static String bucketNameService;
    protected static Bucket bucketPortlet;
    protected static String bucketNamePortlet;
    protected static Bucket bucketJob;
    protected static String bucketNameJob;
    protected static Bucket bucketTask;
    protected static String bucketNameTask;
    private static Map<String, Bucket> connectionMap;

    protected static void prepareConnection(Cluster cluster, AggregatorPersistenceBackendQueryConfiguration configuration) throws Exception {
        String password = configuration.getProperty("password");
        try {
            bucketNameStorage = configuration.getProperty("AggregatedStorageUsageRecord");
            bucketNameService = configuration.getProperty("AggregatedServiceUsageRecord");
            bucketNameJob = configuration.getProperty("AggregatedJobUsageRecord");
            bucketNamePortlet = configuration.getProperty("AggregatedPortletUsageRecord");
            bucketNameTask = configuration.getProperty("AggregatedTaskUsageRecord");
            connectionMap = new HashMap<String, Bucket>();
            bucketStorage = cluster.openBucket(bucketNameStorage, password);
            connectionMap.put("StorageUsageRecord", bucketStorage);
            bucketService = cluster.openBucket(bucketNameService, password);
            connectionMap.put("ServiceUsageRecord", bucketService);
            bucketJob = cluster.openBucket(bucketNameJob, password);
            connectionMap.put("JobUsageRecord", bucketJob);
            bucketPortlet = cluster.openBucket(bucketNamePortlet, password);
            connectionMap.put("PortletUsageRecord", bucketPortlet);
            bucketTask = cluster.openBucket(bucketNameTask, password);
            connectionMap.put("TaskUsageRecord", bucketTask);
        }
        catch (Exception e) {
            logger.error("Bucket connection error");
            throw e;
        }
    }

    public static void searchFile(Cluster cluster, AggregatorPersistenceBackendQueryConfiguration configuration) throws Exception {
        try {
            RecoveryRecord.prepareConnection(cluster, configuration);
            File folderDelete = new File(Constant.PATH_DIR_BACKUP_DELETE);
            if (folderDelete.exists() && folderDelete.isDirectory()) {
                logger.trace("Start Recovery delete");
                File[] listOfFilesDelete = folderDelete.listFiles();
                for (int i = 0; i < listOfFilesDelete.length; ++i) {
                    Boolean result;
                    if (!listOfFilesDelete[i].isFile() || !(result = Boolean.valueOf(RecoveryRecord.ElaborateDeleteFile(Constant.PATH_DIR_BACKUP_DELETE + "/" + listOfFilesDelete[i].getName()))).booleanValue()) continue;
                    logger.trace("Recovery delete complete.. Delete a file");
                    File file = new File(Constant.PATH_DIR_BACKUP_DELETE + "/" + listOfFilesDelete[i].getName());
                    file.delete();
                }
            } else {
                logger.trace("not found files delete");
            }
            File folderInsert = new File(Constant.PATH_DIR_BACKUP_INSERT);
            if (folderInsert.exists() && folderInsert.isDirectory()) {
                logger.trace("Start Recovery insert");
                File[] listOfFilesInsert = folderInsert.listFiles();
                for (int i = 0; i < listOfFilesInsert.length; ++i) {
                    Boolean result;
                    if (!listOfFilesInsert[i].isFile() || !(result = Boolean.valueOf(RecoveryRecord.ElaborateInsertFile(Constant.PATH_DIR_BACKUP_INSERT + "/" + listOfFilesInsert[i].getName()))).booleanValue()) continue;
                    logger.trace("Recovery insert complete.. Delete a file");
                    File file = new File(Constant.PATH_DIR_BACKUP_INSERT + "/" + listOfFilesInsert[i].getName());
                    file.delete();
                }
            } else {
                logger.trace("not found files insert");
            }
        }
        catch (Exception e) {
            logger.error("Error for list file:{}", (Throwable)e);
        }
    }

    public static boolean ElaborateDeleteFile(String nameFile) throws IOException {
        HashMap mapper = (HashMap)new Gson().fromJson((Reader)new FileReader(new File(nameFile)), HashMap.class);
        List docs = (List)mapper.get("docs");
        String recordType = "";
        String usageRecordType = "";
        for (LinkedTreeMap doc : docs) {
            String identifier = (String)doc.get((Object)"id");
            try {
                JsonObject accounting = JsonObject.empty();
                for (String key : doc.keySet()) {
                    accounting.put(key, doc.get((Object)key));
                }
                usageRecordType = accounting.containsKey("usageRecordType") ? (String)doc.get((Object)"usageRecordType") : "";
                recordType = accounting.containsKey("recordType") ? (String)doc.get((Object)"recordType") : "";
                if (recordType.equals("ServiceUsageRecord") || usageRecordType.equals("ServiceUsageRecord")) {
                    bucketService.remove(identifier, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("StorageUsageRecord") || usageRecordType.equals("StorageUsageRecord")) {
                    bucketStorage.remove(identifier, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("JobUsageRecord") || usageRecordType.equals("JobUsageRecord")) {
                    bucketJob.remove(identifier, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("TaskUsageRecord") || usageRecordType.equals("TaskUsageRecord")) {
                    bucketTask.remove(identifier, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (!recordType.equals("PortletUsageRecord") && !usageRecordType.equals("PortletUsageRecord")) continue;
                bucketPortlet.remove(identifier, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
            }
            catch (DocumentDoesNotExistException d) {
                logger.trace("Document id:{} not Exist", (Object)identifier);
            }
            catch (Exception e) {
                logger.error("Problem with recovery file and delete record excepiton:{}", (Object)e.getLocalizedMessage());
                throw e;
            }
        }
        return true;
    }

    public static boolean ElaborateInsertFile(String nameFile) throws IOException {
        HashMap mapper = (HashMap)new Gson().fromJson((Reader)new FileReader(new File(nameFile)), HashMap.class);
        List docs = (List)mapper.get("docs");
        String recordType = "";
        String usageRecordType = "";
        for (LinkedTreeMap doc : docs) {
            String identifier = (String)doc.get((Object)"id");
            try {
                JsonDocument document;
                JsonObject accounting = JsonObject.empty();
                for (String key : doc.keySet()) {
                    accounting.put(key, doc.get((Object)key));
                }
                usageRecordType = accounting.containsKey("usageRecordType") ? (String)doc.get((Object)"usageRecordType") : "";
                recordType = accounting.containsKey("recordType") ? (String)doc.get((Object)"recordType") : "";
                if (usageRecordType == null) {
                    usageRecordType = "";
                }
                if (recordType == null) {
                    recordType = "";
                }
                JsonDocument response = null;
                if (recordType.equals("ServiceUsageRecord") || usageRecordType.equals("ServiceUsageRecord")) {
                    document = JsonDocument.create((String)identifier, (JsonObject)accounting);
                    response = (JsonDocument)bucketService.upsert((Document)document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("StorageUsageRecord") || usageRecordType.equals("StorageUsageRecord")) {
                    document = JsonDocument.create((String)identifier, (JsonObject)accounting);
                    response = (JsonDocument)bucketStorage.upsert((Document)document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("JobUsageRecord") || usageRecordType.equals("JobUsageRecord")) {
                    document = JsonDocument.create((String)identifier, (JsonObject)accounting);
                    response = (JsonDocument)bucketJob.upsert((Document)document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("TaskUsageRecord") || usageRecordType.equals("TaskUsageRecord")) {
                    document = JsonDocument.create((String)identifier, (JsonObject)accounting);
                    response = (JsonDocument)bucketTask.upsert((Document)document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                if (recordType.equals("PortletUsageRecord") || usageRecordType.equals("PortletUsageRecord")) {
                    document = JsonDocument.create((String)identifier, (JsonObject)accounting);
                    response = (JsonDocument)bucketPortlet.upsert((Document)document, PersistTo.MASTER, (long)Constant.CONNECTION_TIMEOUT_BUCKET.intValue(), TimeUnit.SECONDS);
                }
                logger.trace("Elaborate Insert fileJsondocument response:{}", (Object)response);
            }
            catch (Exception e) {
                logger.error("Problem with recovery file and insert record excepiton:{}", (Object)e.getLocalizedMessage());
                throw e;
            }
        }
        return true;
    }
}

