/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.GenericWriteProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.RequestMessage;
import org.bson.io.OutputBuffer;

class UnacknowledgedWriteResultCallback
implements SingleResultCallback<Void> {
    private final SingleResultCallback<WriteConcernResult> callback;
    private final MongoNamespace namespace;
    private final RequestMessage nextMessage;
    private final OutputBuffer writtenBuffer;
    private final boolean ordered;
    private final InternalConnection connection;

    UnacknowledgedWriteResultCallback(SingleResultCallback<WriteConcernResult> callback, MongoNamespace namespace, RequestMessage nextMessage, boolean ordered, OutputBuffer writtenBuffer, InternalConnection connection) {
        this.callback = callback;
        this.namespace = namespace;
        this.nextMessage = nextMessage;
        this.ordered = ordered;
        this.connection = connection;
        this.writtenBuffer = writtenBuffer;
    }

    @Override
    public void onResult(Void result, Throwable t) {
        this.writtenBuffer.close();
        if (t != null) {
            this.callback.onResult(null, t);
        } else if (this.nextMessage != null) {
            new GenericWriteProtocol(this.namespace, this.nextMessage, this.ordered, WriteConcern.UNACKNOWLEDGED).executeAsync(this.connection, this.callback);
        } else {
            this.callback.onResult(WriteConcernResult.unacknowledged(), null);
        }
    }
}

