/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.security.auth.login.Configuration;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.security.authentication.LoginContextProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.ConfigurationUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={AuthenticationConfiguration.class, SecurityConfiguration.class})
public class AuthenticationConfigurationImpl
extends ConfigurationBase
implements AuthenticationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConfigurationImpl.class);

    public AuthenticationConfigurationImpl() {
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    public AuthenticationConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication"));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication";
    }

    @Override
    @Nonnull
    public LoginContextProvider getLoginContextProvider(ContentRepository contentRepository) {
        String appName = this.getParameters().getConfigValue("org.apache.jackrabbit.oak.authentication.appName", "jackrabbit.oak");
        Configuration loginConfig = null;
        try {
            loginConfig = Configuration.getConfiguration();
            if (loginConfig.getAppConfigurationEntry(appName) == null) {
                loginConfig = null;
            }
        }
        catch (SecurityException e) {
            log.info("Failed to retrieve login configuration: using default. " + e);
        }
        if (loginConfig == null) {
            log.debug("No login configuration available for {}; using default", (Object)appName);
            loginConfig = ConfigurationUtil.getDefaultConfiguration(this.getParameters());
        }
        SecurityProvider provider = this.getSecurityProvider();
        Whiteboard whiteboard = null;
        if (provider instanceof WhiteboardAware) {
            whiteboard = ((WhiteboardAware)((Object)provider)).getWhiteboard();
        } else {
            log.warn("Unable to obtain whiteboard from SecurityProvider");
        }
        return new LoginContextProviderImpl(appName, loginConfig, contentRepository, this.getSecurityProvider(), whiteboard);
    }
}

