/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.jackrabbit.oak.security.authentication.token.TokenLoginModule;
import org.apache.jackrabbit.oak.security.authentication.user.LoginModuleImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.GuestLoginModule;

public final class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Configuration getDefaultConfiguration(final ConfigurationParameters loginConfiguration) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
                Map options = loginConfiguration.getConfigValue(applicationName, Collections.emptyMap());
                return new AppConfigurationEntry[]{new DefaultEntry(options)};
            }
        };
    }

    public static Configuration getJackrabbit2Configuration(final ConfigurationParameters loginConfiguration) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
                Map options = loginConfiguration.getConfigValue(applicationName, Collections.emptyMap());
                return new AppConfigurationEntry[]{new GuestEntry(options), new TokenEntry(options), new DefaultEntry(options)};
            }
        };
    }

    private static final class TokenEntry
    extends AppConfigurationEntry {
        private TokenEntry(Map<String, ?> options) {
            super(TokenLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options);
        }
    }

    private static final class GuestEntry
    extends AppConfigurationEntry {
        private GuestEntry(Map<String, ?> options) {
            super(GuestLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, options);
        }
    }

    private static final class DefaultEntry
    extends AppConfigurationEntry {
        private DefaultEntry(Map<String, ?> options) {
            super(LoginModuleImpl.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
    }
}

