/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.aggregation;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.gcube.accounting.aggregator.aggregation.AggregatorBuffer;
import org.gcube.accounting.aggregator.aggregation.DesignID;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator {
    private static Logger logger = LoggerFactory.getLogger(Aggregator.class);
    private static final String TMP_SUFFIX = ".tmp";
    protected final AggregationStatus aggregationStatus;
    protected final Bucket bucket;
    protected final File originalRecordsbackupFile;
    protected final File aggregateRecordsBackupFile;
    protected final File malformedRecordsFile;
    protected int malformedRecordNumber;
    protected Calendar startTime;
    private static final String USAGE_RECORD_TYPE = "usageRecordType";
    private static final String SINGLE = "Single";
    private static final String SIMPLE = "Simple";
    private static final int MAX_RETRY = 3;

    public Aggregator(AggregationStatus aggregationStatus, Bucket bucket, File originalRecordsbackupFile, File aggregateRecordsBackupFile) {
        this.aggregationStatus = aggregationStatus;
        this.bucket = bucket;
        this.originalRecordsbackupFile = originalRecordsbackupFile;
        this.aggregateRecordsBackupFile = aggregateRecordsBackupFile;
        this.malformedRecordsFile = Utility.getMalformatedFile(aggregateRecordsBackupFile);
    }

    public void aggregate() throws Exception {
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.STARTED)) {
            this.startTime = Utility.getUTCCalendarInstance();
            ViewResult viewResult = this.getViewResult();
            this.retrieveAndAggregate(viewResult);
        }
    }

    protected JsonArray generateKey(String key) {
        JsonArray arrayKey = JsonArray.create();
        for (String value : key.split("/")) {
            if (value.toString().isEmpty()) continue;
            arrayKey.add(Integer.parseInt(value));
        }
        return arrayKey;
    }

    protected ViewResult getViewResult() throws Exception {
        DateFormat dateFormat = this.aggregationStatus.getAggregationInfo().getAggregationType().getDateFormat();
        String dateStartKey = dateFormat.format(this.aggregationStatus.getAggregationInfo().getAggregationStartDate());
        String dateEndKey = dateFormat.format(this.aggregationStatus.getAggregationInfo().getAggregationEndDate());
        JsonArray startKey = this.generateKey(dateStartKey);
        JsonArray endKey = this.generateKey(dateEndKey);
        DesignID designid = DesignID.valueOf(this.bucket.name());
        String designDocId = designid.getDesignName();
        String viewName = designid.getViewName();
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.startKey(startKey);
        query.endKey(endKey);
        query.reduce(false);
        query.inclusiveEnd(false);
        logger.debug("View Query: designDocId:{} - viewName:{}, startKey:{} - endKey:{} ", new Object[]{designDocId, viewName, startKey, endKey});
        try {
            return this.bucket.query(query);
        }
        catch (Exception e) {
            logger.error("Exception error VIEW", (Object)e.getLocalizedMessage(), (Object)e);
            throw e;
        }
    }

    protected int elaborateRow(ViewRow row, AggregatorBuffer aggregatorBuffer, int originalRecordsCounter) throws Exception {
        String recordType;
        JsonObject content = (JsonObject)row.document().content();
        if (content.containsKey(USAGE_RECORD_TYPE)) {
            String recordType2 = content.getString(USAGE_RECORD_TYPE);
            content.removeKey(USAGE_RECORD_TYPE);
            content.put("recordType", recordType2);
        }
        Boolean aggregated = false;
        if (content.containsKey("aggregated")) {
            aggregated = content.getBoolean("aggregated");
        }
        if (!aggregated.booleanValue()) {
            recordType = content.getString("recordType");
            content.put("recordType", SINGLE + recordType);
        }
        if ((recordType = content.getString("recordType")).contains(SIMPLE)) {
            recordType.replace(SIMPLE, SINGLE);
        }
        String record = content.toString();
        Utility.printLine(this.originalRecordsbackupFile, record);
        this.aggregateRow(aggregatorBuffer, record);
        if (++originalRecordsCounter % 1000 == 0) {
            int aggregatedRecordsNumber = aggregatorBuffer.getAggregatedRecords().size();
            int diff = originalRecordsCounter - aggregatedRecordsNumber;
            float percentage = 100 * diff / originalRecordsCounter;
            logger.info("{} At the moment, the elaborated original records are {}. The Aggregated records are {}. Difference {}. We are recovering {}% of Documents", new Object[]{this.aggregationStatus.getAggregationInfo(), originalRecordsCounter, aggregatedRecordsNumber, diff, Float.valueOf(percentage)});
        }
        return originalRecordsCounter;
    }

    protected void retrieveAndAggregate(ViewResult viewResult) throws Exception {
        AggregatorBuffer aggregatorBuffer = new AggregatorBuffer();
        Calendar start = Utility.getUTCCalendarInstance();
        logger.debug("Elaboration of Records started at {}", (Object)Constant.DEFAULT_DATE_FORMAT.format(start.getTime()));
        this.originalRecordsbackupFile.delete();
        this.aggregateRecordsBackupFile.delete();
        this.malformedRecordsFile.delete();
        this.malformedRecordNumber = 0;
        int originalRecordsCounter = 0;
        block2: for (ViewRow row : viewResult) {
            for (int i = 1; i <= 3; ++i) {
                try {
                    originalRecordsCounter = this.elaborateRow(row, aggregatorBuffer, originalRecordsCounter);
                    continue block2;
                }
                catch (RuntimeException e) {
                    if (i != 2) continue;
                    logger.error("Unable to elaborate {} {}. Tryed {} times.", new Object[]{ViewRow.class.getSimpleName(), row, i, e});
                    continue;
                }
            }
        }
        Calendar end = Utility.getUTCCalendarInstance();
        long duration = end.getTimeInMillis() - start.getTimeInMillis();
        String durationForHuman = Utility.getHumanReadableDuration(duration);
        logger.debug("{} Elaboration of Records terminated at {}. Duration {}", new Object[]{this.aggregationStatus.getAggregationInfo(), Constant.DEFAULT_DATE_FORMAT.format(end.getTime()), durationForHuman});
        File aggregateRecordsBackupFileTmp = new File(this.aggregateRecordsBackupFile.getParent(), this.aggregateRecordsBackupFile.getName() + TMP_SUFFIX);
        aggregateRecordsBackupFileTmp.delete();
        logger.debug("Going to save {} to file {}", (Object)AggregatedUsageRecord.class.getSimpleName(), (Object)this.aggregateRecordsBackupFile);
        List<AggregatedRecord<?, ?>> aggregatedRecords = aggregatorBuffer.getAggregatedRecords();
        for (AggregatedRecord<?, ?> aggregatedRecord : aggregatedRecords) {
            String marshalled = DSMapper.marshal(aggregatedRecord);
            JsonObject jsonObject = JsonObject.fromJson((String)marshalled);
            Utility.printLine(aggregateRecordsBackupFileTmp, jsonObject.toString());
        }
        aggregateRecordsBackupFileTmp.renameTo(this.aggregateRecordsBackupFile);
        this.aggregationStatus.setRecordNumbers(originalRecordsCounter, aggregatedRecords.size(), this.malformedRecordNumber);
        this.aggregationStatus.setState(AggregationState.AGGREGATED, this.startTime, true);
    }

    protected void aggregateRow(AggregatorBuffer aggregatorBuffer, String json) throws Exception {
        Record record = RecordUtility.getRecord((String)json);
        try {
            record.validate();
        }
        catch (InvalidValueException e) {
            ++this.malformedRecordNumber;
            Utility.printLine(this.malformedRecordsFile, json);
            if (record instanceof AggregatedServiceUsageRecord) {
                if (record.getResourceProperty("minInvocationTime") == null) {
                    record.setResourceProperty("minInvocationTime", record.getResourceProperty("duration"));
                }
                if (record.getResourceProperty("maxInvocationTime") == null) {
                    record.setResourceProperty("maxInvocationTime", record.getResourceProperty("duration"));
                }
                if (record.getResourceProperty("callerQualifier") == null) {
                    record.setResourceProperty("callerQualifier", (Serializable)((Object)"UNKNOWN"));
                }
            }
            record.validate();
        }
        record.setId(UUID.randomUUID().toString());
        AggregatedRecord aggregatedRecord = AggregatorBuffer.getAggregatedRecord(record);
        aggregatorBuffer.aggregate(aggregatedRecord);
    }

    protected JsonDocument getJsonDocument(ViewRow row) {
        String identifier = (String)((JsonObject)row.document().content()).get("id");
        JsonDocument jsonDocument = JsonDocument.create((String)identifier, (JsonObject)((JsonObject)row.document().content()));
        logger.trace("{}", (Object)jsonDocument.toString());
        return jsonDocument;
    }
}

