/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.persist.DocumentElaboration;
import org.gcube.accounting.aggregator.persistence.CouchBaseConnector;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;

public class DeleteDocument
extends DocumentElaboration {
    public DeleteDocument(AggregationStatus aggregationStatus, File file, Bucket bucket) {
        super(aggregationStatus, AggregationState.DELETED, file, bucket, aggregationStatus.getOriginalRecordsNumber());
    }

    @Override
    protected void elaborateLine(String line) throws Exception {
        JsonObject jsonObject = JsonObject.fromJson((String)line);
        String id = jsonObject.getString("id");
        try {
            this.bucket.remove(id, PersistTo.MASTER, CouchBaseConnector.CONNECTION_TIMEOUT_BUCKET, TimeUnit.SECONDS);
        }
        catch (DocumentDoesNotExistException documentDoesNotExistException) {
            // empty catch block
        }
    }

    @Override
    protected void afterElaboration() {
    }
}

