/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.elaboration;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gcube.accounting.aggregator.aggregation.AggregationInfo;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.aggregation.Aggregator;
import org.gcube.accounting.aggregator.directory.FileSystemDirectoryStructure;
import org.gcube.accounting.aggregator.persist.Persist;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.documentstore.records.DSMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elaborator {
    private static Logger logger = LoggerFactory.getLogger(Elaborator.class);
    public static final String ORIGINAL_SUFFIX = ".original.json";
    public static final String AGGREGATED_SUFFIX = ".aggregated.json";
    protected AggregationStatus aggregationStatus;

    public Elaborator(AggregationStatus aggregationStatus) throws Exception {
        this.aggregationStatus = aggregationStatus;
    }

    public boolean isAggregationAllowed() {
        AggregationInfo aggregationInfo = this.aggregationStatus.getAggregationInfo();
        Date aggregationStartDate = aggregationInfo.getAggregationStartDate();
        AggregationType aggregationType = aggregationInfo.getAggregationType();
        boolean allowed = false;
        Calendar calendar = Utility.getUTCCalendarInstance();
        switch (aggregationType) {
            case DAILY: {
                break;
            }
            case MONTHLY: {
                calendar.set(5, 1);
                break;
            }
            case YEARLY: {
                calendar.set(5, 1);
                calendar.set(2, 0);
                break;
            }
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(aggregationType.getCalendarField(), -aggregationType.getNotAggregableBefore());
        logger.trace("Checking if {} is before {}", (Object)aggregationType.getDateFormat().format(aggregationStartDate), (Object)aggregationType.getDateFormat().format(calendar.getTime()));
        if (aggregationStartDate.before(calendar.getTime())) {
            allowed = true;
        }
        return allowed;
    }

    public void elaborate(boolean forceEarlyAggregation, boolean forceRerun, boolean forceRestart, boolean skipAggregation) throws Exception {
        Calendar startTime = Utility.getUTCCalendarInstance();
        AggregationInfo aggregationInfo = this.aggregationStatus.getAggregationInfo();
        Date aggregationStartDate = aggregationInfo.getAggregationStartDate();
        AggregationType aggregationType = aggregationInfo.getAggregationType();
        if (!this.isAggregationAllowed()) {
            if (!forceEarlyAggregation) {
                logger.info("Too early to start aggregation {}. {} Aggregation is not allowed for the last {} {}", new Object[]{DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus), aggregationType, aggregationType.getNotAggregableBefore(), aggregationType.name().toLowerCase().replace("ly", "s").replaceAll("dais", "days")});
                return;
            }
            logger.info("The aggregation has been forced even is too early to start it {}. {} aggregation should not be made for the last {} {}", new Object[]{DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus), aggregationType, aggregationType.getNotAggregableBefore(), aggregationType.name().toLowerCase().replace("ly", "s").replace("dais", "days")});
        }
        if (this.aggregationStatus.getAggregationState() == null) {
            this.aggregationStatus.setAggregationState(AggregationState.STARTED, startTime, true);
        } else {
            if (this.aggregationStatus.getAggregationState() == AggregationState.COMPLETED) {
                if (!forceRerun) {
                    logger.info("{} is {}. Nothing to do :-). \n Details {}", new Object[]{AggregationStatus.class.getSimpleName(), this.aggregationStatus.getAggregationState(), DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus)});
                    return;
                }
                logger.info("Last {} is {} and the aggreation should not be needed but it has been forced. Details {}.", new Object[]{AggregationStatus.class.getSimpleName(), this.aggregationStatus.getAggregationState(), DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus)});
                this.aggregationStatus = new AggregationStatus(this.aggregationStatus);
                this.aggregationStatus.setAggregationState(AggregationState.RESTARTED, startTime, false);
                this.aggregationStatus.setAggregationState(AggregationState.STARTED, startTime, true);
                forceRestart = true;
            }
            Calendar now = Utility.getUTCCalendarInstance();
            now.add(Constant.CALENDAR_FIELD_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED, -Constant.UNIT_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED);
            if (this.aggregationStatus.getLastUpdateTime().after(now)) {
                if (!forceRestart) {
                    logger.info("Cannot elaborate {} because has been modified in the last {} ", new Object[]{DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus), Constant.UNIT_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED, Constant.CALENDAR_FIELD_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED == 11 ? "hours" : "unit"});
                    return;
                }
                logger.info("Normally {} cannot be elaborated because has been modified in the last {} but the restart has been forced", new Object[]{DSMapper.getObjectMapper().writeValueAsString((Object)this.aggregationStatus), Constant.UNIT_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED, Constant.CALENDAR_FIELD_TO_SUBSTRACT_TO_CONSIDER_UNTERMINATED == 11 ? "hours" : "unit"});
            }
            this.aggregationStatus.updateLastUpdateTime(true);
        }
        String recordType = aggregationInfo.getRecordType();
        FileSystemDirectoryStructure fileSystemDirectoryStructure = new FileSystemDirectoryStructure();
        File elaborationDirectory = (File)fileSystemDirectoryStructure.getTargetFolder(aggregationType, aggregationStartDate);
        File originalRecordsbackupFile = this.getOriginalRecordsBackupFile(elaborationDirectory, recordType);
        File aggregateRecordsBackupFile = this.getAggregatedRecordsBackupFile(originalRecordsbackupFile);
        Aggregator aggregator = new Aggregator(this.aggregationStatus, originalRecordsbackupFile, aggregateRecordsBackupFile);
        aggregator.setSkipAggregation(skipAggregation);
        aggregator.aggregate();
        Persist persist = new Persist(this.aggregationStatus, originalRecordsbackupFile, aggregateRecordsBackupFile, recordType);
        persist.recover();
    }

    public static File getOriginalRecordsBackupFile(File elaborationDirectory, AggregationInfo aggregationInfo) {
        String recordType = aggregationInfo.getRecordType();
        Date aggregationStartDate = aggregationInfo.getAggregationStartDate();
        AggregationType aggregationType = aggregationInfo.getAggregationType();
        DateFormat dateFormat = aggregationType.getDateFormat();
        String dateString = dateFormat.format(aggregationStartDate);
        String[] splittedDate = dateString.split("/");
        String backupFileName = splittedDate[splittedDate.length - 1] + "-" + recordType;
        File originalRecordsbackupFile = new File(elaborationDirectory, backupFileName + ORIGINAL_SUFFIX);
        return originalRecordsbackupFile;
    }

    protected File getOriginalRecordsBackupFile(File elaborationDirectory, String name) throws Exception {
        AggregationInfo aggregationInfo = this.aggregationStatus.getAggregationInfo();
        Date aggregationStartDate = aggregationInfo.getAggregationStartDate();
        AggregationType aggregationType = aggregationInfo.getAggregationType();
        DateFormat dateFormat = aggregationType.getDateFormat();
        String dateString = dateFormat.format(aggregationStartDate);
        String[] splittedDate = dateString.split("/");
        String backupFileName = splittedDate[splittedDate.length - 1] + "-" + name;
        File originalRecordsbackupFile = new File(elaborationDirectory, backupFileName + ORIGINAL_SUFFIX);
        return originalRecordsbackupFile;
    }

    protected File getAggregatedRecordsBackupFile(File originalRecordsbackupFile) throws Exception {
        File aggregateRecordsBackupFile = new File(originalRecordsbackupFile.getParentFile(), originalRecordsbackupFile.getName().replace(ORIGINAL_SUFFIX, AGGREGATED_SUFFIX));
        return aggregateRecordsBackupFile;
    }
}

