/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import org.gcube.accounting.aggregator.directory.WorkSpaceDirectoryStructure;
import org.gcube.accounting.aggregator.persist.DeleteDocument;
import org.gcube.accounting.aggregator.persist.InsertDocument;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.aggregator.workspace.WorkSpaceManagement;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persist {
    protected static Logger logger = LoggerFactory.getLogger(Persist.class);
    protected final AggregationStatus aggregationStatus;
    protected final File originalRecordsbackupFile;
    protected final File aggregateRecordsBackupFile;
    protected final String recordType;

    public Persist(AggregationStatus aggregationStatus, File originalRecordsbackupFile, File aggregateRecordsBackupFile, String recordType) {
        this.aggregationStatus = aggregationStatus;
        this.originalRecordsbackupFile = originalRecordsbackupFile;
        this.aggregateRecordsBackupFile = aggregateRecordsBackupFile;
        this.recordType = recordType;
    }

    private void setAggregationStateToCompleted(Calendar now) throws Exception {
        this.originalRecordsbackupFile.delete();
        this.aggregateRecordsBackupFile.delete();
        File malformedRecords = Utility.getMalformatedFile(this.aggregateRecordsBackupFile);
        if (malformedRecords.exists()) {
            malformedRecords.delete();
        }
        this.aggregationStatus.setAggregationState(AggregationState.COMPLETED, now, true);
    }

    public void recover() throws Exception {
        if (this.aggregationStatus.getAggregatedRecordsNumber() == this.aggregationStatus.getOriginalRecordsNumber()) {
            Calendar now = Utility.getUTCCalendarInstance();
            if (this.aggregationStatus.getAggregatedRecordsNumber() == 0) {
                this.setAggregationStateToCompleted(now);
                return;
            }
        }
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.AGGREGATED)) {
            DeleteDocument deleteDocument = new DeleteDocument(this.aggregationStatus, this.originalRecordsbackupFile);
            deleteDocument.elaborate();
        }
        InsertDocument insertDocument = new InsertDocument(this.aggregationStatus, this.aggregateRecordsBackupFile);
        boolean serviceUsageRecordElaboration = this.recordType.compareTo(((ServiceUsageRecord)ServiceUsageRecord.class.newInstance()).getRecordType()) == 0;
        insertDocument.setServiceUsageRecordElaboration(serviceUsageRecordElaboration);
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.DELETED)) {
            insertDocument.elaborate();
        }
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.ADDED)) {
            Calendar now = Utility.getUTCCalendarInstance();
            WorkSpaceDirectoryStructure workspaceDirectoryStructure = new WorkSpaceDirectoryStructure();
            FolderContainer targetFolder = (FolderContainer)workspaceDirectoryStructure.getTargetFolder(this.aggregationStatus.getAggregationInfo().getAggregationType(), this.aggregationStatus.getAggregationInfo().getAggregationStartDate());
            ArrayList<File> files = new ArrayList<File>();
            files.add(this.originalRecordsbackupFile);
            files.add(this.aggregateRecordsBackupFile);
            String zipFilename = this.originalRecordsbackupFile.getName().replace(".original.json", "");
            File malformedRecords = Utility.getMalformatedFile(this.aggregateRecordsBackupFile);
            if (malformedRecords.exists()) {
                files.add(malformedRecords);
                zipFilename = this.originalRecordsbackupFile.getName().replace(".original.json", "-with-malformed");
            }
            if (serviceUsageRecordElaboration) {
                files.add(insertDocument.getCalledMethodCSVFile());
            }
            WorkSpaceManagement.getInstance().zipAndBackupFiles(targetFolder, zipFilename, files);
            this.setAggregationStateToCompleted(now);
        }
    }
}

