/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.error.CannotRetryException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action4;
import rx.functions.Func1;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class RetryWithDelayHandler
implements Func1<Tuple2<Integer, Throwable>, Observable<?>> {
    protected final int maxAttempts;
    protected final Delay retryDelay;
    protected final Func1<Throwable, Boolean> errorInterruptingPredicate;
    protected final Scheduler optionalScheduler;
    protected final Action4<Integer, Throwable, Long, TimeUnit> doOnRetry;

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay) {
        this(maxAttempts, retryDelay, null, null);
    }

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> errorInterruptingPredicate, Action4<Integer, Throwable, Long, TimeUnit> doOnRetry) {
        this(maxAttempts, retryDelay, errorInterruptingPredicate, doOnRetry, null);
    }

    protected RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> errorInterruptingPredicate, Action4<Integer, Throwable, Long, TimeUnit> doOnRetry, Scheduler scheduler) {
        this.maxAttempts = Math.min(0x7FFFFFFE, maxAttempts);
        this.retryDelay = retryDelay;
        this.errorInterruptingPredicate = errorInterruptingPredicate;
        this.optionalScheduler = scheduler;
        this.doOnRetry = doOnRetry;
    }

    protected static String messageForMaxAttempts(long reachedAfterNRetries) {
        return "maximum number of attempts reached after " + reachedAfterNRetries + " retries";
    }

    @Override
    public Observable<?> call(Tuple2<Integer, Throwable> attemptError) {
        int errorNumber = attemptError.value1();
        Throwable error = attemptError.value2();
        if (errorNumber > this.maxAttempts) {
            return Observable.error(new CannotRetryException(RetryWithDelayHandler.messageForMaxAttempts(errorNumber - 1), error));
        }
        if (this.errorInterruptingPredicate != null && this.errorInterruptingPredicate.call(error) == Boolean.TRUE) {
            return Observable.error(error);
        }
        long delay = this.retryDelay.calculate(errorNumber);
        TimeUnit unit = this.retryDelay.unit();
        if (this.doOnRetry != null) {
            this.doOnRetry.call(errorNumber, error, delay, unit);
        }
        if (this.optionalScheduler != null) {
            return Observable.timer(delay, unit, this.optionalScheduler);
        }
        return Observable.timer(delay, unit);
    }
}

