/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.util.retry.RetryWhenFunction;
import com.couchbase.client.java.util.retry.RetryWithDelayHandler;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func2;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class Retry {
    public static final Delay DEFAULT_DELAY = Delay.fixed(1L, TimeUnit.MILLISECONDS);

    public static <T> Observable<T> wrapForRetry(Observable<T> source, int maxAttempts) {
        return Retry.wrapForRetry(source, new RetryWithDelayHandler(maxAttempts, DEFAULT_DELAY));
    }

    public static <T> Observable<T> wrapForRetry(Observable<T> source, int maxAttempts, Delay retryDelay) {
        return Retry.wrapForRetry(source, new RetryWithDelayHandler(maxAttempts, retryDelay));
    }

    public static <T> Observable<T> wrapForRetry(Observable<T> source, RetryWithDelayHandler handler) {
        return source.retryWhen(new RetryWhenFunction(handler));
    }

    protected static Observable<Tuple2<Integer, Throwable>> errorsWithAttempts(Observable<? extends Throwable> errors, int expectedAttempts) {
        return errors.zipWith(Observable.range(1, expectedAttempts), new Func2<Throwable, Integer, Tuple2<Integer, Throwable>>(){

            @Override
            public Tuple2<Integer, Throwable> call(Throwable error, Integer attempt) {
                return Tuple.create(attempt, error);
            }
        });
    }
}

