/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.LegacyDocument;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LegacyTranscoder
extends AbstractTranscoder<LegacyDocument, Object> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(LegacyTranscoder.class);
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    static final int SERIALIZED = 1;
    static final int COMPRESSED = 2;
    private static final int SPECIAL_MASK = 65280;
    static final int SPECIAL_BOOLEAN = 256;
    static final int SPECIAL_INT = 512;
    static final int SPECIAL_LONG = 768;
    static final int SPECIAL_DATE = 1024;
    static final int SPECIAL_BYTE = 1280;
    static final int SPECIAL_FLOAT = 1536;
    static final int SPECIAL_DOUBLE = 1792;
    static final int SPECIAL_BYTEARRAY = 2048;
    private final int compressionThreshold;

    public LegacyTranscoder() {
        this(16384);
    }

    public LegacyTranscoder(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    @Override
    public Class<LegacyDocument> documentType() {
        return LegacyDocument.class;
    }

    @Override
    protected LegacyDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        Object decoded = null;
        if ((flags & 2) != 0) {
            data = this.decompress(data);
        }
        int maskedFlags = flags & 0xFF00;
        if ((flags & 1) != 0 && data != null) {
            decoded = this.deserialize(data);
        } else if (maskedFlags != 0 && data != null) {
            switch (maskedFlags) {
                case 256: {
                    decoded = data[0] == 49;
                    break;
                }
                case 512: {
                    decoded = (int)LegacyTranscoder.decodeLong(data);
                    break;
                }
                case 768: {
                    decoded = LegacyTranscoder.decodeLong(data);
                    break;
                }
                case 1024: {
                    decoded = new Date(LegacyTranscoder.decodeLong(data));
                    break;
                }
                case 1280: {
                    decoded = data[0];
                    break;
                }
                case 1536: {
                    decoded = Float.valueOf(Float.intBitsToFloat((int)LegacyTranscoder.decodeLong(data)));
                    break;
                }
                case 1792: {
                    decoded = Double.longBitsToDouble(LegacyTranscoder.decodeLong(data));
                    break;
                }
                case 2048: {
                    decoded = data;
                    break;
                }
                default: {
                    LOGGER.warn("Undecodeable with flags %x", (Object)flags);
                    break;
                }
            }
        } else {
            decoded = new String(data, CharsetUtil.UTF_8);
        }
        return this.newDocument(id, expiry, decoded, cas);
    }

    @Override
    public LegacyDocument newDocument(String id, int expiry, Object content, long cas) {
        return LegacyDocument.create(id, expiry, content, cas);
    }

    @Override
    public LegacyDocument newDocument(String id, int expiry, Object content, long cas, MutationToken mutationToken) {
        return LegacyDocument.create(id, expiry, content, cas, mutationToken);
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(LegacyDocument document) throws Exception {
        byte[] compressed;
        int flags = 0;
        Object content = document.content();
        ByteBuf encoded = Unpooled.buffer();
        if (content instanceof String) {
            encoded.writeBytes(((String)content).getBytes(CharsetUtil.UTF_8));
        } else if (content instanceof Long) {
            flags |= 0x300;
            encoded.writeBytes(LegacyTranscoder.encodeNum((Long)content, 8));
        } else if (content instanceof Integer) {
            flags |= 0x200;
            encoded.writeBytes(LegacyTranscoder.encodeNum(((Integer)content).intValue(), 4));
        } else if (content instanceof Boolean) {
            flags |= 0x100;
            boolean b = (Boolean)content;
            encoded = Unpooled.buffer().writeByte(b ? 49 : 48);
        } else if (content instanceof Date) {
            flags |= 0x400;
            encoded.writeBytes(LegacyTranscoder.encodeNum(((Date)content).getTime(), 8));
        } else if (content instanceof Byte) {
            flags |= 0x500;
            encoded.writeByte(((Byte)content).byteValue());
        } else if (content instanceof Float) {
            flags |= 0x600;
            encoded.writeBytes(LegacyTranscoder.encodeNum(Float.floatToRawIntBits(((Float)content).floatValue()), 4));
        } else if (content instanceof Double) {
            flags |= 0x700;
            encoded.writeBytes(LegacyTranscoder.encodeNum(Double.doubleToRawLongBits((Double)content), 8));
        } else if (content instanceof byte[]) {
            flags |= 0x800;
            encoded.writeBytes((byte[])content);
        } else {
            flags |= 1;
            encoded.writeBytes(LegacyTranscoder.serialize(content));
        }
        if (encoded.readableBytes() >= this.compressionThreshold && (compressed = this.compress(encoded.copy().array())).length < encoded.array().length) {
            encoded.clear().writeBytes(compressed);
            flags |= 2;
        }
        return Tuple.create(encoded, flags);
    }

    public static byte[] encodeNum(long l, int maxBytes) {
        int firstNon0;
        byte[] rv = new byte[maxBytes];
        for (int i = 0; i < rv.length; ++i) {
            int pos = rv.length - i - 1;
            rv[pos] = (byte)(l >> 8 * i & 0xFFL);
        }
        for (firstNon0 = 0; firstNon0 < rv.length && rv[firstNon0] == 0; ++firstNon0) {
        }
        if (firstNon0 > 0) {
            byte[] tmp = new byte[rv.length - firstNon0];
            System.arraycopy(rv, firstNon0, tmp, 0, rv.length - firstNon0);
            rv = tmp;
        }
        return rv;
    }

    public static long decodeLong(byte[] b) {
        long rv = 0L;
        for (int n : b) {
            rv = rv << 8 | (long)(n < 0 ? 256 + n : n);
        }
        return rv;
    }

    private static byte[] serialize(Object content) {
        if (content == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(content);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not close output stream.", ex);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not close byte output stream.", ex);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserialize(byte[] in) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Caught IOException decoding %d bytes of data", (Object)(in == null ? 0 : in.length), (Object)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Caught CNFE decoding %d bytes of data", (Object)(in == null ? 0 : in.length), (Object)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not close input stream.", ex);
            }
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not close byte input stream.", ex);
            }
        }
        return rv;
    }

    protected byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            try {
                if (gz != null) {
                    gz.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not close gzip output stream.", ex);
            }
            try {
                bos.close();
            }
            catch (Exception ex) {
                LOGGER.error("Could not close byte output stream.", ex);
            }
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[8192];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not decompress data.", e);
                bos = null;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not close byte output stream.", ex);
                }
                try {
                    if (gis != null) {
                        gis.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not close gzip input stream.", ex);
                }
                try {
                    bis.close();
                }
                catch (Exception ex) {
                    LOGGER.error("Could not close byte input stream.", ex);
                }
            }
        }
        return bos == null ? null : bos.toByteArray();
    }
}

