/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import rx.Subscription;
import rx.functions.Func1;
import rx.internal.util.ObjectPool;
import rx.internal.util.PlatformDependent;

public final class IndexedRingBuffer<E>
implements Subscription {
    private static final ObjectPool<IndexedRingBuffer<?>> POOL;
    private final ElementSection<E> elements = new ElementSection();
    private final IndexSection removed = new IndexSection();
    final AtomicInteger index = new AtomicInteger();
    final AtomicInteger removedIndex = new AtomicInteger();
    static int _size;
    static final int SIZE;

    public static final <T> IndexedRingBuffer<T> getInstance() {
        return POOL.borrowObject();
    }

    public void releaseToPool() {
        int maxIndex = this.index.get();
        int realIndex = 0;
        ElementSection section = this.elements;
        block0: while (section != null) {
            int i = 0;
            while (i < SIZE) {
                if (realIndex >= maxIndex) {
                    section = null;
                    break block0;
                }
                section.array.set(i, null);
                ++i;
                ++realIndex;
            }
            section = (ElementSection)section.next.get();
        }
        this.index.set(0);
        this.removedIndex.set(0);
        POOL.returnObject(this);
    }

    @Override
    public void unsubscribe() {
        this.releaseToPool();
    }

    private IndexedRingBuffer() {
    }

    public int add(E e) {
        int i = this.getIndexForAdd();
        if (i < SIZE) {
            ((ElementSection)this.elements).array.set(i, e);
            return i;
        }
        int sectionIndex = i % SIZE;
        ((ElementSection)this.getElementSection(i)).array.set(sectionIndex, e);
        return i;
    }

    public E remove(int index) {
        E e;
        if (index < SIZE) {
            e = ((ElementSection)this.elements).array.getAndSet(index, null);
        } else {
            int sectionIndex = index % SIZE;
            e = ((ElementSection)this.getElementSection(index)).array.getAndSet(sectionIndex, null);
        }
        this.pushRemovedIndex(index);
        return e;
    }

    private IndexSection getIndexSection(int index) {
        if (index < SIZE) {
            return this.removed;
        }
        int numSections = index / SIZE;
        IndexSection a = this.removed;
        for (int i = 0; i < numSections; ++i) {
            a = a.getNext();
        }
        return a;
    }

    private ElementSection<E> getElementSection(int index) {
        if (index < SIZE) {
            return this.elements;
        }
        int numSections = index / SIZE;
        ElementSection<E> a = this.elements;
        for (int i = 0; i < numSections; ++i) {
            a = a.getNext();
        }
        return a;
    }

    private synchronized int getIndexForAdd() {
        int i;
        int ri = this.getIndexFromPreviouslyRemoved();
        if (ri >= 0) {
            if (ri < SIZE) {
                i = this.removed.getAndSet(ri, -1);
            } else {
                int sectionIndex = ri % SIZE;
                i = this.getIndexSection(ri).getAndSet(sectionIndex, -1);
            }
            if (i == this.index.get()) {
                this.index.getAndIncrement();
            }
        } else {
            i = this.index.getAndIncrement();
        }
        return i;
    }

    private synchronized int getIndexFromPreviouslyRemoved() {
        int currentRi;
        while ((currentRi = this.removedIndex.get()) > 0) {
            if (!this.removedIndex.compareAndSet(currentRi, currentRi - 1)) continue;
            return currentRi - 1;
        }
        return -1;
    }

    private synchronized void pushRemovedIndex(int elementIndex) {
        int i = this.removedIndex.getAndIncrement();
        if (i < SIZE) {
            this.removed.set(i, elementIndex);
        } else {
            int sectionIndex = i % SIZE;
            this.getIndexSection(i).set(sectionIndex, elementIndex);
        }
    }

    @Override
    public boolean isUnsubscribed() {
        return false;
    }

    public int forEach(Func1<? super E, Boolean> action) {
        return this.forEach(action, 0);
    }

    public int forEach(Func1<? super E, Boolean> action, int startIndex) {
        int endedAt = this.forEach(action, startIndex, this.index.get());
        if (startIndex > 0 && endedAt == this.index.get()) {
            endedAt = this.forEach(action, 0, startIndex);
        } else if (endedAt == this.index.get()) {
            endedAt = 0;
        }
        return endedAt;
    }

    private int forEach(Func1<? super E, Boolean> action, int startIndex, int endIndex) {
        int lastIndex = startIndex;
        int maxIndex = this.index.get();
        int realIndex = startIndex;
        ElementSection section = this.elements;
        if (startIndex >= SIZE) {
            section = this.getElementSection(startIndex);
            startIndex %= SIZE;
        }
        block0: while (section != null) {
            int i = startIndex;
            while (i < SIZE) {
                if (realIndex >= maxIndex || realIndex >= endIndex) {
                    section = null;
                    break block0;
                }
                Object element = section.array.get(i);
                if (element != null) {
                    lastIndex = realIndex;
                    boolean continueLoop = action.call(element);
                    if (!continueLoop) {
                        return lastIndex;
                    }
                }
                ++i;
                ++realIndex;
            }
            section = (ElementSection)section.next.get();
            startIndex = 0;
        }
        return realIndex;
    }

    static {
        String sizeFromProperty;
        POOL = new ObjectPool<IndexedRingBuffer<?>>(){

            @Override
            protected IndexedRingBuffer<?> createObject() {
                return new IndexedRingBuffer();
            }
        };
        _size = 256;
        if (PlatformDependent.isAndroid()) {
            _size = 8;
        }
        if ((sizeFromProperty = System.getProperty("rx.indexed-ring-buffer.size")) != null) {
            try {
                _size = Integer.parseInt(sizeFromProperty);
            }
            catch (Exception e) {
                System.err.println("Failed to set 'rx.indexed-ring-buffer.size' with value " + sizeFromProperty + " => " + e.getMessage());
            }
        }
        SIZE = _size;
    }

    private static class IndexSection {
        private final AtomicIntegerArray unsafeArray = new AtomicIntegerArray(SIZE);
        private final AtomicReference<IndexSection> _next = new AtomicReference();

        private IndexSection() {
        }

        public int getAndSet(int expected, int newValue) {
            return this.unsafeArray.getAndSet(expected, newValue);
        }

        public void set(int i, int elementIndex) {
            this.unsafeArray.set(i, elementIndex);
        }

        IndexSection getNext() {
            if (this._next.get() != null) {
                return this._next.get();
            }
            IndexSection newSection = new IndexSection();
            if (this._next.compareAndSet(null, newSection)) {
                return newSection;
            }
            return this._next.get();
        }
    }

    private static class ElementSection<E> {
        private final AtomicReferenceArray<E> array = new AtomicReferenceArray(SIZE);
        private final AtomicReference<ElementSection<E>> next = new AtomicReference();

        private ElementSection() {
        }

        ElementSection<E> getNext() {
            if (this.next.get() != null) {
                return this.next.get();
            }
            ElementSection<E> newSection = new ElementSection<E>();
            if (this.next.compareAndSet(null, newSection)) {
                return newSection;
            }
            return this.next.get();
        }
    }
}

