/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.accounting.common.helper.TimeHelper;
import org.gcube.accounting.datamodel.AbstractDelegateUsageRecord;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

@XmlRootElement(name="usageRecord")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class VMUsageRecord
extends AbstractDelegateUsageRecord {
    public static final String TYPE_VM = "VM";
    private static final String REF_VM = "refVM";
    private static final String REF_HOST = "refHost";
    private static final String USAGE_START = "usageStart";
    private static final String USAGE_END = "usageEnd";
    private static final String CORES = "cores";

    public VMUsageRecord(UsageRecord ur) {
        super(ur);
        this.setResourceType(TYPE_VM);
    }

    public VMUsageRecord() {
        this(new RawUsageRecord());
    }

    public String getRefVM() {
        return this.getResourceSpecificProperty(REF_VM);
    }

    public void setRefVM(String refVM) {
        this.setResourceSpecificProperty(REF_VM, refVM);
    }

    public Integer getCores() {
        try {
            return Integer.parseInt(this.getResourceSpecificProperty(CORES));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setCores(Integer cores) throws InvalidValueException {
        if (cores == null) {
            return;
        }
        if (cores < 0) {
            throw new InvalidValueException("number of cores cannot be less than zero");
        }
        this.setResourceSpecificProperty(CORES, cores.toString());
    }

    public String getRefHost() {
        return this.getResourceSpecificProperty(REF_HOST);
    }

    public void setRefHost(String refHost) {
        this.setResourceSpecificProperty(REF_HOST, refHost);
    }

    public Calendar getUsageStart() {
        try {
            String usageStart = this.getResourceSpecificProperty(USAGE_START);
            if (usageStart != null) {
                return TimeHelper.getCalendar(usageStart);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Calendar getUsageEnd() {
        try {
            String usageEnd = this.getResourceSpecificProperty(USAGE_END);
            if (usageEnd != null) {
                return TimeHelper.getCalendar(usageEnd);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setUsageStart(Calendar usageStart) throws InvalidValueException {
        if (this.getStartTime() != null && usageStart.before(this.getStartTime())) {
            throw new InvalidValueException("usageStart cannot be before startTime");
        }
        if (this.getUsageEnd() != null && usageStart.after(this.getUsageEnd())) {
            throw new InvalidValueException("usageStart cannot be after usageEnd");
        }
        if (this.getEndTime() != null && usageStart.after(this.getEndTime())) {
            throw new InvalidValueException("usageStart cannot be after endTime");
        }
        this.setResourceSpecificProperty(USAGE_START, Long.toString(usageStart.getTimeInMillis()));
    }

    public void setUsageEnd(Calendar usageEnd) throws InvalidValueException {
        if (this.getStartTime() != null && usageEnd.before(this.getStartTime())) {
            throw new InvalidValueException("usageEnd cannot be before startTime");
        }
        if (this.getUsageStart() != null && usageEnd.before(this.getUsageStart())) {
            throw new InvalidValueException("usageEnd cannot be before usageStart");
        }
        if (this.getEndTime() != null && usageEnd.after(this.getEndTime())) {
            throw new InvalidValueException("usageEnd cannot be after endTime");
        }
        this.setResourceSpecificProperty(USAGE_END, Long.toString(usageEnd.getTimeInMillis()));
    }

    @Override
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        if (this.getUsageStart() != null && startTime.after(this.getUsageStart())) {
            throw new InvalidValueException("startTime cannot be after usageStart");
        }
        if (this.getUsageEnd() != null && startTime.after(this.getUsageEnd())) {
            throw new InvalidValueException("startTime cannot be after usageEnd");
        }
        super.setStartTime(startTime);
    }

    @Override
    public void validate() throws InvalidValueException {
        super.validate();
        if (!TYPE_VM.toString().equals(this.getResourceType())) {
            throw new InvalidValueException("field 'resourceType' must be 'VM'");
        }
        if (this.getUsageStart() == null) {
            throw new InvalidValueException("field 'usageStart' is mandatory");
        }
        if (this.getUsageEnd() == null) {
            throw new InvalidValueException("field 'usageEnd' is mandatory");
        }
        if (this.getRefVM() == null) {
            throw new InvalidValueException("field 'refVM' is mandatory");
        }
    }
}

