/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel.billing;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.gcube.accounting.datamodel.serialization.AdaptedMapEntry;

@XmlAccessorType(XmlAccessType.FIELD)
public class Property {

	@XmlAttribute(name = "name", required = true)
	private String key;

	@XmlAttribute(name = "value", required = true)
	private String value;

	@XmlElement(name="category")
	private List<AdaptedMapEntry> category;

	public Property() {
		this(null, null, null);
	}

	public Property(String key, String value) {
		this(key, value, null);
	}

	public Property(String key, String value, Map<String, Object> category) {
		this.key = key;
		this.value = value;
		if ( category != null ) {
			this.category = new LinkedList<AdaptedMapEntry>();
			for ( Entry<String, Object> entry : category.entrySet()) {
				this.category.add(new AdaptedMapEntry(entry.getKey(), "" + entry.getValue()));
			}
		}
	}

	public List<AdaptedMapEntry> getCategory() {
		return category;
	}
	
	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}
}
