/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel.query;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;
import org.gcube.accounting.exception.QueryFormatException;

public class QueryHelper {

	private static Logger logger = Logger.getLogger(QueryHelper.class);

	/**
	 * Parse a string of the form "k1=v1&k2=v2&k3=v3..." and produces a Map
	 * with the <key-value> pairs from the query
	 * @param query
	 * @return
	 */
	public static Map<String, QueryClause> parseQuery(String query) throws QueryFormatException {
		Map<String, QueryClause> out = new HashMap<String, QueryClause>();
		if(query==null)
			return out;
		StringTokenizer st = new StringTokenizer(query, "&");
		while(st.hasMoreTokens()) {
			String kv = st.nextToken();
			if(kv!=null)
				kv = kv.replaceAll("%%", "&");
			QueryClause clause = new QueryClause(kv); 
			out.put(clause.getKey(), clause);
		}
		return out;
	}
	
	public static Calendar getCalendar(Map<String, QueryClause> clauses, QueryField field) {
		return QueryHelper.getCalendar(clauses, field.toString());
	}
	
	public static Calendar getCalendar(Map<String, QueryClause> clauses, String field) {
		QueryClause qc = clauses.get(field);
		if (qc == null)
			return null;
		try {
			Long d = Long.parseLong(qc.getValue());
			Calendar out = Calendar.getInstance();
			out.setTimeInMillis(d);
			return out;
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static String getString(Map<String, QueryClause> clauses, QueryField field) {
		QueryClause qc = clauses.get(field.toString());
		if (qc == null)
			return null;
		return qc.getValue();
	}

}
