/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.security.authz;

public class Permission {

	/**
	 * The identity of the user
	 */
	private String userId;

	/**
	 * The user role over the target
	 */
	private Role role;

	/**
	 * The target of the permission
	 */
	private String target;

	/**
	 * Empty constructor
	 */
	public Permission() {
	}

	/**
	 * Full constructor
	 */
	public Permission(String userId, String target, Role role) {
		this();
		this.setUserId(userId);
		this.setTarget(target);
		this.setRole(role);
	}

	/**
	 * Return the user identity
	 * 
	 * @return
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * Set the user identity
	 * 
	 * @param userId
	 */
	public void setUserId(String userId) {
		if (userId != null)
			this.userId = userId.trim();
	}

	/**
	 * Return the user role
	 * 
	 * @return
	 */
	public Role getRole() {
		return role;
	}

	/**
	 * Set the user role over the target
	 * 
	 * @param role
	 */
	public void setRole(Role role) {
		this.role = role;
	}

	/**
	 * Return the target of the permission
	 * 
	 * @return
	 */
	public String getTarget() {
		return target;
	}

	/**
	 * Set the target of the permission
	 * 
	 * @param target
	 */
	public void setTarget(String target) {
		if (target != null)
			this.target = target.trim();
	}

	/**
	 * Check whether the given action is allowed by this permission
	 * 
	 * @param a
	 * @return
	 */
	public boolean isAllowed(Action a) {
		return role.isAllowed(a);
	}

	/**
	 * Check whether the given action on the given target is allowed by this
	 * permission
	 * 
	 * @param a
	 * @param object
	 * @return
	 */
	public boolean isAllowed(Action a, String object) {
		if (!this.isAllowed(a))
			return false;
		if (object != null && object.trim().startsWith(target))
			return true;
		return false;
	}

	/**
	 * Provide a string representation for this permission
	 */
	public String toString() {
		return this.userId + ":" + this.role.getName() + ":" + this.target;
	}

}
