/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.webservice.configuration;

public abstract class BaseConfiguration implements NetworkConfiguration,
		SecurityConfiguration {

	public boolean isAuthnEnabled() {
		return this.getBoolean("authn.enabled", false);
	}

	public boolean isAuthzEnabled() {
		return this.getBoolean("authz.enabled", false);
	}
	
	public String getRealm() {
		String realm = this.getString("authn.realm");
		if(realm==null || realm.trim().equals(""))
			realm = "unknown";
		return realm;
	}

	public String getProxyHost() {
		return this.getString("proxyHost");
	}

	public String getProxyPort() {
		return this.getString("proxyPort");
	}

	public String getProxyUser() {
		return this.getString("proxyUser");
	}

	public String getProxyPassword() {
		return this.getString("proxyPassword");
	}

	public abstract String getString(String key);

	public abstract Boolean getBoolean(String key);

	public abstract Boolean getBoolean(String key, Boolean def);

}
