/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.webservice.configuration;

import java.util.List;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

/**
 * This class models Usage Tracker configuration. It relies on the configuration
 * location defined in the context file.
 */
public class PropertiesBaseConfiguration extends BaseConfiguration {

	/**
	 * A logger for this class
	 */
	protected static Logger logger = Logger.getLogger(PropertiesBaseConfiguration.class);
	
	/**
	 * The inner configuration (from commons-configuration)
	 */
	private static PropertiesConfiguration configuration;

	
	/**
	 * Private constructor
	 */
	protected PropertiesBaseConfiguration(String path) {
		try {
			logger.info("Loading configuration: " + path);

			// load the configuration
			configuration = new PropertiesConfiguration(path);

			// set the reloading strategy to enable hot-configuration
			FileChangedReloadingStrategy fcrs = new FileChangedReloadingStrategy();
			configuration.setReloadingStrategy(fcrs);
		}
		catch(ConfigurationException e) {
			e.printStackTrace();
		}
	}

	public String getString(String key) {
		return configuration.getString(key);
	}
	
	public Boolean getBoolean(String key) {
		return configuration.getBoolean(key);
	}

	public Boolean getBoolean(String key, Boolean def) {
		return configuration.getBoolean(key, def);
	}
	
	public Integer getInt(String key, Integer def) {
		return configuration.getInt(key, def);
	}

	public Integer getInt(String key) {
		return configuration.getInt(key);
	}
	
	public List<String> getList(String key) {
		return (List<String>)configuration.getList(key);
	}

}
