/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.accounting.datamodel.AbstractDelegateUsageRecord;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

@XmlRootElement(name="usageRecord")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class NetworkUsageRecord
extends AbstractDelegateUsageRecord {
    public static final String TYPE_NETWORK = "network";
    private static final String OVERALL_NETWORK_IN = "overallNetworkIn";
    private static final String PERIOD_NETWORK_IN = "periodNetworkIn";
    private static final String OVERALL_NETWORK_OUT = "overallNetworkOut";
    private static final String PERIOD_NETWORK_OUT = "periodNetworkOut";
    private static final String REF_VM = "refVM";

    public NetworkUsageRecord(UsageRecord ur) {
        super(ur);
        this.setResourceType(TYPE_NETWORK);
    }

    public NetworkUsageRecord() {
        this(new RawUsageRecord());
    }

    @XmlElement(name="periodNetworkIn")
    public String getPeriodNetworkIn() {
        return this.getResourceSpecificProperty(PERIOD_NETWORK_IN);
    }

    public void setPeriodNetworkIn(Long netIn) throws InvalidValueException {
        if (netIn < 0L) {
            throw new InvalidValueException("network usage cannot be less than zero");
        }
        this.setResourceSpecificProperty(PERIOD_NETWORK_IN, netIn.toString());
    }

    public void setPeriodNetworkOut(Long netOut) throws InvalidValueException {
        if (netOut < 0L) {
            throw new InvalidValueException("network usage cannot be less than zero");
        }
        this.setResourceSpecificProperty(PERIOD_NETWORK_OUT, netOut.toString());
    }

    @XmlElement(name="periodNetworkOut")
    public String getPeriodNetworkOut() {
        return this.getResourceSpecificProperty(PERIOD_NETWORK_OUT);
    }

    public void setOverallNetworkIn(Long netIn) throws InvalidValueException {
        if (netIn < 0L) {
            throw new InvalidValueException("network usage cannot be less than zero");
        }
        this.setResourceSpecificProperty(OVERALL_NETWORK_IN, netIn.toString());
    }

    @XmlElement(name="overallNetworkIn")
    public String getOverallNetworkIn() {
        return this.getResourceSpecificProperty(OVERALL_NETWORK_IN);
    }

    public void setOverallNetworkOut(Long netOut) throws InvalidValueException {
        if (netOut < 0L) {
            throw new InvalidValueException("network usage cannot be less than zero");
        }
        this.setResourceSpecificProperty(OVERALL_NETWORK_OUT, netOut.toString());
    }

    @XmlElement(name="overallNetworkOut")
    public String getOverallNetworkOut() {
        return this.getResourceSpecificProperty(OVERALL_NETWORK_OUT);
    }

    @XmlElement(name="refVM")
    public String getRefVM() {
        return this.getResourceSpecificProperty(REF_VM);
    }

    public void setRefVM(String refVM) {
        this.setResourceSpecificProperty(REF_VM, refVM);
    }

    @Override
    public void validate() throws InvalidValueException {
        super.validate();
        if (!TYPE_NETWORK.toString().equals(this.getResourceType())) {
            throw new InvalidValueException("field 'resourceType' must be '" + TYPE_NETWORK.toString() + "'");
        }
    }
}

