/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import java.security.cert.X509Certificate;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;

public class X509Filter implements Filter {

	private static Logger logger = Logger.getLogger(X509Filter.class);

	public void init(FilterConfig arg0) throws ServletException {
	}

	/**
	 * Just create an attribute named 'requestorDN' containing the DN of the
	 * user making the request
	 */
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {

		HttpServletResponse response = (HttpServletResponse) res;

		// check if authN is enabled
		if(!SecurityManager.isAuthnEnabled()) {
			chain.doFilter(req, res);
			return;
		}
		
		// this filter only work with X509 security
		if(!"x509".equals(SecurityManager.getAuthnType())) {
			chain.doFilter(req, res);
			return;
		}

		// extract the current DN
		String requestDN = this.getUserDN(req);

		// if no DN is found, reject request
		// TODO: is this the correct way to reject?
		if(requestDN!=null) {
			// setting the DN as request attribute
			// TODO: obsolete; start using 'userId' (see below)
			req.setAttribute("requestorDN", requestDN);

			// setting the DN as request attribute
			req.setAttribute("userId", requestDN);
			
			// proceed
			chain.doFilter(req, res);
			return;
		}

		// finally sending code 401
//		String realm = SecurityManager.getAuthenticationManager().getRealm();
//		response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
		((HttpServletResponse)res).sendError(HttpServletResponse.SC_UNAUTHORIZED);

	}

	/**
	 * Return the DN in the first X509 certificate (if any) in the request
	 * 
	 * @param req
	 * @return
	 */
	private String getUserDN(ServletRequest req) {
		X509Certificate certs[] = this.getCerts(req);
		if (certs != null && certs.length > 0) {
			return certs[0].getSubjectDN().getName();
		} else {
			return null;
		}
	}

	/**
	 * Return all X509 certificates shipped along with the request
	 * 
	 * @param req
	 * @return
	 */
	private X509Certificate[] getCerts(ServletRequest req) {
		return (X509Certificate[]) req
				.getAttribute("javax.servlet.request.X509Certificate");
	}

	public void destroy() {
	}

}
