/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authz;

import org.apache.log4j.Logger;
import org.gcube.accounting.exception.NotFoundException;

public enum Action {
    READ_RECORD("readRecord", "can read usage records"),
    WRITE_RECORD("writeRecord", "can create new usage records"),
    UPDATE_RECORD("updateRecord", "can update an existing usage record"),
    DELETE_RECORD("deleteRecord", "can delete an existing usage record"),
    READ_BILL("readBill", "can read a bill"),
    ACT_AS_DELEGATE("actAsDelegate", "can act on behalf of someone else");

    private static Logger logger;
    private String name;
    private String description;

    private Action(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public static Action getAction(String s) throws NotFoundException {
        logger.debug((Object)s);
        if (Action.READ_RECORD.name.equals(s)) {
            return READ_RECORD;
        }
        if (Action.WRITE_RECORD.name.equals(s)) {
            return WRITE_RECORD;
        }
        if (Action.UPDATE_RECORD.name.equals(s)) {
            return UPDATE_RECORD;
        }
        if (Action.DELETE_RECORD.name.equals(s)) {
            return DELETE_RECORD;
        }
        if (Action.READ_BILL.name.equals(s)) {
            return READ_BILL;
        }
        if (Action.ACT_AS_DELEGATE.name.equals(s)) {
            return ACT_AS_DELEGATE;
        }
        throw new NotFoundException();
    }

    static {
        logger = Logger.getLogger(Action.class);
    }
}

