/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Group extends Consumer {

	/**
	 * the name of the group
	 */
	private String name;
	
	/**
	 * the path up to the root group
	 */
	private List<String> path;
	
	/**
	 * the properties of the group
	 */
	private Map<String, String[]> properties;

	public Group() {
		super();
		this.properties = new HashMap<String, String[]>();
	}

	public Group(String name) {
		this();
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the path
	 */
	@XmlElement(name="pathelement")
	@XmlElementWrapper(name="path")
  	public List<String> getPath() {
		return path;
	}

	/**
	 * @param path
	 *            the path to set
	 */
	public void setPath(List<String> path) {
		this.path = path;
	}

	/**
	 * @return the properties
	 */
	public Map<String, String[]> getProperties() {
		return properties;
	}

	/**
	 * @param properties
	 *            the properties to set
	 */
	public void setProperties(Map<String, String[]> properties) {
		this.properties = properties;
	}

	public void addProperty(String name, String[] value) {
		this.properties.put(name, value);
	}

	public String[] getProperty(String name) {
		return this.properties.get(name);
	}

}
