/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.accounting.datamodel.serialization.PropertiesAdapter;

/**
 * 
 * This object represent an userid membership
 * 
 */

@XmlRootElement(name = "membership")
public class Membership {

	/**
	 * The user identity
	 */
	private String identity;
	
	/**
	 * The position of the user in the organisation hierarchy
	 */
	private Collection<String> hierarchy;
	
	/**
	 * Arbitrary user properties (multivalue)
	 */
	private Map<String, List<String>> properties;

	public Membership() {
		super();
	}
	
	public Membership(String identity, Collection<String> hierarchy,
			Map<String, List<String>> properties) {
		this();
		this.identity = identity;
		this.hierarchy = hierarchy;
		this.properties = properties;
	}

	/**
	 * 
	 * @return Current user's identity
	 */
	@XmlAttribute
	public String getIdentity() {
		return identity;
	}

	/**
	 * 
	 * @param identity
	 *            Identity to set
	 */
	public void setIdentity(String identity) {
		this.identity = identity;
	}

	/**
	 * 
	 * @return Current user's hierarchy
	 */
	@XmlElementWrapper(name = "hierarchy")
	@XmlElement(name = "branch")
	public Collection<String> getHierarchy() {
		return hierarchy;
	}

	/**
	 * 
	 * @param hierarchy
	 *            Hierarchy to set
	 */
	public void setHierarchy(Collection<String> hierarchy) {
		this.hierarchy = hierarchy;
	}

	/**
	 * Since java.util.Map is an unmappable class, an equivalent mappable class
	 * {@link org.venusc.mab.membership.datamodel.serialization.AdaptedList
	 * AdaptedMap} is created. During marshal/unmarshal operations the instance
	 * of Map is treated as an instance of AdaptedMap.
	 * 
	 * @return Current user's properties
	 */
	@XmlJavaTypeAdapter(PropertiesAdapter.class)
	public Map<String, List<String>> getProperties() {
		if (properties == null)
			properties = new HashMap<String, List<String>>();
		return properties;
	}

	/**
	 * 
	 * @param properties
	 *            Properties to set
	 */
	public void setProperties(Map<String, List<String>> properties) {
		this.properties = properties;
	}

}
