/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel.billing;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(XmlAccessType.FIELD)
public class PolicyResult {

	@XmlAttribute(name="policy-name")
	private String policyName;
	
	@XmlElement(name="property")
	private List<Property> properties;
	
	@XmlElement(name="feeds")
	private FeedSet feeds;
		
	public PolicyResult() {
	}
	
	public PolicyResult(String policyName) {
		super();
		this.policyName = policyName;
	}
	
	public List<Property> getProperties() {
		return properties;
	}

	public void setProperties(List<Property> properties) {
		this.properties = properties;
	}

	public void setFeeds(FeedSet feeds) {
		this.feeds = feeds;
	}
	
	public FeedSet getFeeds() {
		return feeds;
	}

	public String getPolicyName() {
		return policyName;
	}

	public void setPolicyName(String policyName) {
		this.policyName = policyName;
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("PolicyResult {\n");
		if ( properties != null ) {
			for ( Property property : properties ) {
				buffer.append("\t* " + property + "\n");
			}
		}
		buffer.append("}\n");
		return buffer.toString();
	}
	
}
