/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.datamodel.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class MapAdaptor extends
		XmlAdapter<AdaptedMap, java.util.Map<String, String>> {

	@Override
	public AdaptedMap marshal(Map<String, String> v) throws Exception {
		AdaptedMap myMap = new AdaptedMap();
		List<AdaptedMapEntry> aList = myMap.getA();
		for (Map.Entry<String, String> e : v.entrySet()) {
			aList.add(new AdaptedMapEntry(e.getKey(), e.getValue()));
		}
		return myMap;
	}

	@Override
	public Map<String, String> unmarshal(AdaptedMap v) throws Exception {
		Map<String, String> map = new HashMap<String, String>();
		for (AdaptedMapEntry e : v.getA()) {
			map.put(e.getKey(), e.getValue());
		}
		return map;
	}
}
