/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.accounting.datamodel.AbstractDelegateUsageRecord;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

@XmlRootElement(name="usageRecord")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class StorageRecord
extends AbstractDelegateUsageRecord {
    public static final String STORAGE = "storage";
    private static final String STORAGE_VOLUME = "storageVolume";
    private static final String STORAGE_TRANSACTIONS = "storageTransactions";
    private static final String STORAGE_ITEMS = "itemCount";
    private static final String STORAGE_CONTEXT = "context";

    public StorageRecord() {
        this(new RawUsageRecord());
    }

    public StorageRecord(UsageRecord ur) {
        super(ur);
        this.setResourceType(STORAGE);
    }

    public void setStorageVolume(Long volume) throws InvalidValueException {
        if (volume < 0L) {
            throw new InvalidValueException("volume cannot be less than zero");
        }
        this.setResourceSpecificProperty(STORAGE_VOLUME, volume.toString());
    }

    @XmlElement(name="storageVolume")
    public long getStorageVolume() {
        try {
            return Long.parseLong(this.ur.getResourceSpecificProperty(STORAGE_VOLUME));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setStorageTransactions(Long transactions) throws InvalidValueException {
        if (transactions < 0L) {
            throw new InvalidValueException("transaction number cannot be less than zero");
        }
        this.setResourceSpecificProperty(STORAGE_TRANSACTIONS, transactions.toString());
    }

    @XmlElement(name="storageTransactions")
    public long getStorageTransactions() {
        try {
            return Long.parseLong(this.ur.getResourceSpecificProperty(STORAGE_TRANSACTIONS));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setItemCount(Long items) throws InvalidValueException {
        if (items < 0L) {
            throw new InvalidValueException("items number cannot be less than zero");
        }
        this.setResourceSpecificProperty(STORAGE_ITEMS, items.toString());
    }

    @XmlElement(name="itemCount")
    public long getItemCount() {
        try {
            return Long.parseLong(this.ur.getResourceSpecificProperty(STORAGE_ITEMS));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setStorageContext(String context) {
        if (context != null) {
            this.setResourceSpecificProperty(STORAGE_CONTEXT, context);
        }
    }

    public String getStorageContext() {
        return this.getResourceSpecificProperty(STORAGE_CONTEXT);
    }

    @Override
    public void validate() throws InvalidValueException {
        super.validate();
        if (!STORAGE.toString().equals(this.getResourceType())) {
            throw new InvalidValueException("field 'resourceType' must be '" + STORAGE.toString() + "'");
        }
    }
}

