/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.query;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryField;
import org.gcube.accounting.exception.QueryFormatException;

public class QueryHelper {
    private static Logger logger = Logger.getLogger(QueryHelper.class);

    public static Map<String, QueryClause> parseQuery(String query) throws QueryFormatException {
        HashMap<String, QueryClause> out = new HashMap<String, QueryClause>();
        if (query == null) {
            return out;
        }
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            if (kv != null) {
                kv = kv.replaceAll("%%", "&");
            }
            QueryClause clause = new QueryClause(kv);
            out.put(clause.getKey(), clause);
        }
        return out;
    }

    public static Calendar getCalendar(Map<String, QueryClause> clauses, QueryField field) {
        return QueryHelper.getCalendar(clauses, field.toString());
    }

    public static Calendar getCalendar(Map<String, QueryClause> clauses, String field) {
        QueryClause qc = clauses.get(field);
        if (qc == null) {
            return null;
        }
        try {
            Long d = Long.parseLong(qc.getValue());
            Calendar out = Calendar.getInstance();
            out.setTimeInMillis(d);
            return out;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getString(Map<String, QueryClause> clauses, QueryField field) {
        QueryClause qc = clauses.get(field.toString());
        if (qc == null) {
            return null;
        }
        return qc.getValue();
    }
}

