/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.ut;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.Collection;
import java.util.Vector;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.AbstractDelegateUsageRecord;
import org.gcube.accounting.datamodel.Consumer;
import org.gcube.accounting.datamodel.JobUsageRecord;
import org.gcube.accounting.datamodel.NetworkUsageRecord;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.StorageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.User;
import org.gcube.accounting.datamodel.VMUsageRecord;
import org.gcube.accounting.security.authn.HTTPBasicAuthentication;
import org.gcube.accounting.ut.UpdateInfo;

public class UsageTrackerRestAPI {
    private static Logger logger = Logger.getLogger(UsageTrackerRestAPI.class);
    private WebResource service;
    private Client client;
    private String uri;

    public UsageTrackerRestAPI(String uri) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create((ClientConfig)config);
        this.uri = uri;
        this.service = this.client.resource(UsageTrackerRestAPI.getBaseURI(this.uri));
    }

    private static URI getBaseURI(String uri) {
        return UriBuilder.fromUri((String)uri).build(new Object[0]);
    }

    public void insertUsageRecords(Collection<UsageRecord> records) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("bulk upload of " + records.size() + " usage records..."));
        for (UsageRecord ur : records) {
            this.insertUsageRecord(ur);
        }
        logger.debug((Object)"bulk upload completed");
    }

    public void insertUsageRecord(UsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("uploading usage record " + ur.getId() + "..."));
        ((WebResource.Builder)this.service.path("usagerecords").accept(new String[]{"text/plain"}).type("application/xml")).post((Object)ur);
        logger.debug((Object)"uploaded");
    }

    public void insertUsageRecord(AbstractDelegateUsageRecord ur) {
        this.insertUsageRecord(ur.getDelegateUR());
    }

    public void insertUsageRecord(VMUsageRecord ur) {
        logger.debug((Object)("uploading vm usage record " + ur.getId() + "..."));
        this.service = this.client.resource(this.uri);
        ((WebResource.Builder)this.service.path("usagerecords").path("vm").accept(new String[]{"text/plain"}).type("application/xml")).post((Object)ur);
        logger.debug((Object)"uploaded");
    }

    public void insertUsageRecord(NetworkUsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("uploading network usage record " + ur.getId() + "..."));
        ((WebResource.Builder)this.service.path("usagerecords").path("network").accept(new String[]{"text/plain"}).type("application/xml")).post((Object)ur);
        logger.debug((Object)"uploaded");
    }

    public void insertUsageRecord(StorageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("uploading storage usage record " + ur.getId() + "..."));
        ((WebResource.Builder)this.service.path("usagerecords").path("storage").accept(new String[]{"text/plain"}).type("application/xml")).post((Object)ur);
        logger.debug((Object)"uploaded");
    }

    public void insertUsageRecord(JobUsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("uploading job usage record " + ur.getId() + "..."));
        ((WebResource.Builder)this.service.path("usagerecords").path("job").accept(new String[]{"text/plain"}).type("application/xml")).post((Object)ur);
        logger.debug((Object)"uploaded");
    }

    public void updateUsageRecord(UsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug((Object)("updating usage record " + ur.getId() + "..."));
        ((WebResource.Builder)this.service.path("usagerecords").path(ur.getId()).accept(new String[]{"text/plain"}).type("application/xml")).put((Object)ur);
        logger.debug((Object)"updated");
    }

    public void updateUsageRecord(AbstractDelegateUsageRecord ur) {
        this.updateUsageRecord(ur.getDelegateUR());
    }

    public Collection<UsageRecord> getUsageRecords(String query) {
        this.service = this.client.resource(this.uri);
        RawUsageRecord[] records = (RawUsageRecord[])this.service.path("usagerecords").queryParam("query", query).get(RawUsageRecord[].class);
        logger.debug((Object)("retrieved " + records.length + " usage records"));
        Vector<UsageRecord> out = new Vector<UsageRecord>();
        for (RawUsageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<UsageRecord> getUsageRecordsByQuery(String query) {
        return this.getUsageRecords(query);
    }

    public Collection<VMUsageRecord> getVMRecords(String query) {
        this.service = this.client.resource(this.uri);
        VMUsageRecord[] records = (VMUsageRecord[])this.service.path("usagerecords").path("vm").queryParam("query", query).get(VMUsageRecord[].class);
        logger.debug((Object)("retrieved " + records.length + " vm records"));
        Vector<VMUsageRecord> out = new Vector<VMUsageRecord>();
        for (VMUsageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<VMUsageRecord> getVMRecordsByQuery(String query) {
        return this.getVMRecords(query);
    }

    public Collection<NetworkUsageRecord> getNetworkRecords(String query) {
        this.service = this.client.resource(this.uri);
        NetworkUsageRecord[] records = (NetworkUsageRecord[])this.service.path("usagerecords").path("network").queryParam("query", query).get(NetworkUsageRecord[].class);
        logger.debug((Object)("retrieved " + records.length + " network records"));
        Vector<NetworkUsageRecord> out = new Vector<NetworkUsageRecord>();
        for (NetworkUsageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<NetworkUsageRecord> getNetworkRecordsByQuery(String query) {
        return this.getNetworkRecords(query);
    }

    public Collection<StorageRecord> getStorageRecords(String query) {
        this.service = this.client.resource(this.uri);
        StorageRecord[] records = (StorageRecord[])this.service.path("usagerecords").path("storage").queryParam("query", query).get(StorageRecord[].class);
        logger.debug((Object)("retrieved " + records.length + " storage records"));
        Vector<StorageRecord> out = new Vector<StorageRecord>();
        for (StorageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<StorageRecord> getStorageRecordsByQuery(String query) {
        return this.getStorageRecords(query);
    }

    public Collection<JobUsageRecord> getJobrecords(String query) {
        this.service = this.client.resource(this.uri);
        JobUsageRecord[] records = (JobUsageRecord[])this.service.path("usagerecords").path("job").queryParam("query", query).get(JobUsageRecord[].class);
        logger.debug((Object)("retrieved " + records.length + " job records"));
        Vector<JobUsageRecord> out = new Vector<JobUsageRecord>();
        for (JobUsageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<UpdateInfo> getUpdateInfo() {
        logger.debug((Object)"querying the Usage Tracker for update information...");
        this.service = this.client.resource(this.uri);
        UpdateInfo[] infos = (UpdateInfo[])this.service.path("meta").path("update_info").get(UpdateInfo[].class);
        logger.debug((Object)"done");
        Vector<UpdateInfo> out = new Vector<UpdateInfo>();
        for (UpdateInfo info : infos) {
            out.add(info);
        }
        return out;
    }

    public Collection<User> getUsers() {
        logger.debug((Object)"retrieving tracked users...");
        this.service = this.client.resource(this.uri);
        User[] users = (User[])this.service.path("meta").path("users").get(User[].class);
        logger.debug((Object)("retrieved " + users.length + " users"));
        Vector<User> out = new Vector<User>();
        for (User user : users) {
            out.add(user);
        }
        return out;
    }

    public Collection<Consumer> getTrackedConsumers() {
        this.service = this.client.resource(this.uri);
        Consumer[] consumers = (Consumer[])this.service.path("meta").path("consumers").get(Consumer[].class);
        Vector<Consumer> out = new Vector<Consumer>();
        for (Consumer c : consumers) {
            out.add(c);
        }
        return out;
    }

    public void clear() {
        logger.debug((Object)"clearing the usage tracker...");
        this.service = this.client.resource(this.uri);
        this.service.path("usagerecords").delete();
        logger.debug((Object)"done");
    }

    public Collection<UsageRecord> getUsageRecordByProperty(String key, String value) {
        logger.debug((Object)("retrieving usage records where '" + key + "' is '" + value + "'..."));
        return this.getUsageRecordsByQuery(key + "=" + value);
    }

    public void deleteUsageRecord(UsageRecord record) {
        this.service = this.client.resource(this.uri);
        logger.info((Object)("deleting usage record " + record.getId() + "..."));
        this.service.path("usagerecords/" + record.getId()).delete();
        logger.info((Object)"deleted");
    }

    public void setUserToken(String username, String password) {
        this.client.addFilter((ClientFilter)new HTTPBasicAuthentication(username, password));
    }

    public void setUserToken(String username, String password, String delegator) {
        this.client.addFilter((ClientFilter)new HTTPBasicAuthentication(username, password, delegator));
    }
}

