/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.webservice.configuration;

import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.gcube.accounting.webservice.configuration.BaseConfiguration;

public class PropertiesBaseConfiguration
extends BaseConfiguration {
    protected static Logger logger = Logger.getLogger(PropertiesBaseConfiguration.class);
    private static PropertiesConfiguration configuration;

    protected PropertiesBaseConfiguration(String path) {
        try {
            logger.info((Object)("Loading configuration: " + path));
            configuration = new PropertiesConfiguration(path);
            FileChangedReloadingStrategy fcrs = new FileChangedReloadingStrategy();
            configuration.setReloadingStrategy((ReloadingStrategy)fcrs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getString(String key) {
        return configuration.getString(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return configuration.getBoolean(key);
    }

    @Override
    public Boolean getBoolean(String key, Boolean def) {
        return configuration.getBoolean(key, def);
    }

    @Override
    public Integer getInt(String key, Integer def) {
        return configuration.getInt(key, def.intValue());
    }

    @Override
    public Integer getInt(String key) {
        return configuration.getInt(key);
    }

    @Override
    public List<String> getList(String key) {
        return configuration.getList(key);
    }
}

