/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.serialization.MapAdaptor;
import org.gcube.accounting.exception.InvalidValueException;

@XmlRootElement(name="usageRecord")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RawUsageRecord
implements UsageRecord,
Serializable {
    private static final long serialVersionUID = 5714960796256372093L;
    private String id = UUID.randomUUID().toString();
    private Calendar createTime;
    private Calendar modifyTime;
    private String creatorId;
    private String consumerId;
    private String fullyQualifiedConsumerId;
    private Calendar startTime;
    private Calendar endTime;
    private String resourceOwner;
    @XmlJavaTypeAdapter(value=MapAdaptor.class)
    @XmlElement(name="resourceSpecificProperties")
    private Map<String, String> extension = new HashMap<String, String>();
    @XmlJavaTypeAdapter(value=MapAdaptor.class)
    @XmlElement(name="customProperties")
    private Map<String, String> custom = new HashMap<String, String>();
    private String aggregatedId;
    private String resourceType;

    public RawUsageRecord() {
    }

    public RawUsageRecord(UsageRecord r) throws InvalidValueException {
        this();
        this.setAggregatedId(r.getAggregatedId());
        this.setConsumerId(r.getConsumerId());
        this.setFullyQualifiedConsumerId(r.getFullyQualifiedConsumerId());
        this.setCreateTime(r.getCreateTime());
        this.setModifyTime(r.getModifyTime());
        this.setCreatorId(r.getCreatorId());
        this.setEndTime(r.getEndTime());
        this.setId(r.getId());
        this.setResourceOwner(r.getResourceOwner());
        this.setResourceType(r.getResourceType());
        this.setStartTime(r.getStartTime());
        for (String s : r.getResourceSpecificProperties().keySet()) {
            this.setResourceSpecificProperty(s, r.getResourceSpecificProperty(s));
        }
        for (String s : r.getCustomProperties().keySet()) {
            this.setCustomProperty(s, r.getCustomProperty(s));
        }
    }

    @Override
    public Calendar getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Calendar createTime) {
        this.createTime = createTime;
    }

    @Override
    public Calendar getModifyTime() {
        return this.modifyTime;
    }

    @Override
    public void setModifyTime(Calendar modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    @XmlElement(name="creatorId")
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    @Override
    @XmlElement(name="consumerId")
    public String getConsumerId() {
        return this.consumerId;
    }

    @Override
    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    @Override
    public String getFullyQualifiedConsumerId() {
        return this.fullyQualifiedConsumerId;
    }

    @Override
    public void setFullyQualifiedConsumerId(String fqcid) {
        this.fullyQualifiedConsumerId = fqcid;
    }

    @Override
    @XmlElement(name="startTime")
    public Calendar getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        if (this.getEndTime() != null && startTime.after(this.getEndTime())) {
            throw new InvalidValueException("startTime cannot be after endTime");
        }
        this.startTime = startTime;
    }

    @Override
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        if (this.getStartTime() != null && endTime.before(this.getStartTime())) {
            throw new InvalidValueException("endTime cannot be before startTime");
        }
        this.endTime = endTime;
    }

    @Override
    @XmlElement(name="endTime")
    public Calendar getEndTime() {
        return this.endTime;
    }

    @Override
    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setResourceSpecificProperty(String name, String value) {
        this.extension.put(name, value);
    }

    @Override
    public String getResourceSpecificProperty(String key) {
        return this.extension.get(key);
    }

    @Override
    public void setCustomProperty(String name, String value) {
        this.custom.put(name, value);
    }

    @Override
    public String getCustomProperty(String name) {
        return this.custom.get(name);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getAggregatedId() {
        return this.aggregatedId;
    }

    @Override
    public void setAggregatedId(String aggregatedId) {
        this.aggregatedId = aggregatedId;
    }

    @Override
    @XmlElement(name="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    @XmlElement(name="resourceOwner")
    public String getResourceOwner() {
        return this.resourceOwner;
    }

    @Override
    public void setResourceOwner(String owner) {
        this.resourceOwner = owner;
    }

    @Override
    @XmlJavaTypeAdapter(value=MapAdaptor.class)
    public Map<String, String> getResourceSpecificProperties() {
        return this.extension;
    }

    @Override
    @XmlJavaTypeAdapter(value=MapAdaptor.class)
    public Map<String, String> getCustomProperties() {
        return this.custom;
    }

    @Override
    public void setCustomProperties(Map<String, String> props) {
        this.custom = props;
    }

    @Override
    public void setResourceSpecificProperties(Map<String, String> props) {
        this.extension = props;
    }

    @Override
    public void validate() {
    }
}

