/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.security;

import org.gcube.accounting.security.authn.AuthenticationManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.security.authz.AuthorizationManager;

/**
 * A class providing a single access point to security objects and configuration
 * 
 */
public class SecurityManager {

	private static boolean authnEnabled;
	private static boolean authzEnabled;
	
	private static AuthenticationManager authn;
	private static AuthorizationManager authz;
	
	private static String authnType;
	
	public static String getAuthnType() {
		return SecurityManager.authnType;
	}

	public static void setAuthnType(String authnType) {
		SecurityManager.authnType = authnType;
	}

	public static AuthenticationManager getAuthenticationManager() {
		return authn;
	}

	public static void setAuthenticationManager(AuthenticationManager authn) {
		SecurityManager.authn = authn;
	}

	public static void setAuthorizationManager(AuthorizationManager authz) {
		SecurityManager.authz = authz;
	}

	public static AuthorizationManager getAuthorizationManager() {
		return authz;
	}

	public static boolean isAuthnEnabled() {
		return authnEnabled;
	}

	public static void setAuthnEnabled(boolean authnEnabled) {
		SecurityManager.authnEnabled = authnEnabled;
	}
	
	public static boolean isAuthzEnabled() {
		return authzEnabled;
	}

	public static void setAuthzEnabled(boolean authzEnabled) {
		SecurityManager.authzEnabled = authzEnabled;
	}
	
	public static boolean isAllowed(String userId, Action action) {
		// authorization is disabled. Allow all.
		if(!authzEnabled)
			return true;
		// authz is enabled, but no service available. Deny all.
		if(authz==null)
			return false;
		// ask authorization manager
		return getAuthorizationManager().isAllowed(userId, action);
	}

	public static boolean isAllowed(String userId, Action action, String object) {
		// authorization is disabled. Allow all.
		if(!authzEnabled)
			return true;
		// authz is enabled, but no service available. Deny all.
		if(authz==null)
			return false;
		// ask authorization manager
		return getAuthorizationManager().isAllowed(userId, action, object);
	}
	
	public static boolean authenticate(String username, String password) {
		// authentication is disabled. Allow all.
		if(!authnEnabled)
			return true;
		// authn is enabled, but no service available. Deny all.
		if(authn==null)
			return false;
		// ask authentication manager
		return getAuthenticationManager().authenticate(username, password);
	}

}
