/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.security.authn.filter;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;


public class SessionFilter implements Filter {

	private static Logger logger = Logger.getLogger(SessionFilter.class);

//	private HttpSession session;
	
	public void init(FilterConfig filterConfig) throws ServletException {
	}

	public void destroy() {
	}

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) 
			throws java.io.IOException, ServletException {
		HttpServletRequest httprequest = (HttpServletRequest)request;
		HttpServletResponse httpresponse = (HttpServletResponse)response;

		// checking if authz is enabled
		if(!SecurityManager.isAuthnEnabled()) {
			chain.doFilter(request, response);
			return;
		}

		// check whether the filter applies or not
		if(!"session".equals(SecurityManager.getAuthnType())) {
			chain.doFilter(request, response);
			return;
		}
		
		// retrieving session
		HttpSession session = httprequest.getSession(false);

		// requesting login ... no need to authenticate
		if(httprequest.getRequestURI().endsWith("login.jsp")) {
			chain.doFilter(request, response);
			return;
		}

		// asking for logout. Invalidate the session and redirect to login
		if(httprequest.getRequestURI().endsWith("logout.jsp")) {
			logger.debug("logging out...");
			if(session != null){
				logger.debug("invalidating session...");
				synchronized( session ) {
					session.invalidate();
				}
			}
			session = httprequest.getSession(true);
			logger.debug("redirecting to login");
			httpresponse.sendRedirect(httprequest.getContextPath()+"/login.jsp");
			chain.doFilter(request, response);
			return;
		}

		// valid session
		session = httprequest.getSession();
		if(session.getAttribute("userId")!=null) {
			logger.debug("valid session. going ahead.");
			logger.debug(session.getAttribute("userId"));
			request.setAttribute("userId", session.getAttribute("userId"));
			chain.doFilter(request, response);
			return;
		}

		// username + password provided
		String username = request.getParameter("username");
		String password = request.getParameter("password");
		if(username!=null && password!=null) {
			boolean isAuthenticated = SecurityManager.authenticate(username, password);
			if(isAuthenticated) {
				logger.debug("authenticated. Going ahead with request");
				session.setAttribute("userId", username);
				request.setAttribute("userId", username);
				chain.doFilter(request, response);
				return;
			}
		}

		// to get here:
		// 1) not a login page
		// 2) invalid session
		// 3) credentials not provided
		// thus: not authenticated
		logger.debug("redirecting to login...");
		httpresponse.sendRedirect(httprequest.getContextPath()+"/login.jsp");
		return;

	}

}

