/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.security.authz;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Role {

	/**
	 * The role name
	 */
	private String name;

	/**
	 * A set of actions for this role
	 */
	private Set<Action> actions;

	/**
	 * Empty constructor
	 */
	private Role() {
		this.actions = new HashSet<Action>();
	}

	/**
	 * Basic constructor
	 * 
	 * @param name
	 */
	public Role(String name) {
		this();
		this.setName(name);
	}

	/**
	 * Set the role name
	 * 
	 * @param name
	 */
	public void setName(String name) {
		if (name != null)
			this.name = name.trim();
	}

	/**
	 * Return the name of the role
	 * 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Check whether the role can perform the given action
	 * 
	 * @param action
	 * @return
	 */
	public boolean isAllowed(Action action) {
		return actions.contains(action);
	}

	/**
	 * Add the given action to this role
	 * 
	 * @param act
	 */
	public void addAction(Action act) {
		this.actions.add(act);
	}

	/**
	 * Add the given actions to this role
	 * 
	 * @param acts
	 */
	public void addActions(Action... acts) {
		for (Action a : acts)
			this.actions.add(a);
	}

	/**
	 * Add the given actions to this role
	 * 
	 * @param actions
	 */
	public void addActions(Collection<Action> actions) {
		this.actions.addAll(actions);
	}

}
