/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.ut;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * A class modeling the update status of the usage tracker for a given
 * infrastructure (a.k.a. resource owner)
 * 
 */

@XmlRootElement
public class UpdateInfo {

	private String dci;
	private Long timestamp;

	public UpdateInfo() {
	}

	public UpdateInfo(String dci, Long timestamp) {
		this.dci = dci;
		this.timestamp = timestamp;
	}

	/**
	 * Return a reference to the infrastructure
	 * 
	 * @return
	 */
	public String getDci() {
		return dci;
	}

	/**
	 * Set a reference to the infrastructure
	 */
	public void setDci(String dci) {
		this.dci = dci;
	}

	/**
	 * Return the last time a usage record has been published for the
	 * infrastructure
	 * 
	 * @return
	 */
	public Long getTimestamp() {
		return timestamp;
	}

	/**
	 * Set the last time a usage record has been published for the
	 * infrastructure
	 * 
	 * @return
	 */
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

}
