

package org.gcube.accounting.security.authn;

import org.apache.commons.codec.binary.Base64;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
  
public class HTTPBasicAuthentication extends ClientFilter {

	    private String userName;
	    private String userPassword;
	    private String delegator;
	  
	    
	    public HTTPBasicAuthentication(String username, String password) {
	    	this.userName = username;
	    	this.userPassword = password;
	    }
	    
	    public HTTPBasicAuthentication(String username, String password, String delegator) {
	    	this.userName = username;
	    	this.userPassword = password;
	    	this.delegator = delegator;
	    }

		@Override 
		public ClientResponse handle(ClientRequest cr) 
				throws ClientHandlerException { 
			cr.getHeaders().remove("Authorization");
			cr.getHeaders().remove("delegatorId");
			String authorization = new String(Base64.encodeBase64String((userName+":"+userPassword).getBytes()));
			cr.getHeaders().add("Authorization", "Basic " + authorization);
			cr.getHeaders().add("delegatorId", delegator);
			return getNext().handle(cr);
		}

		public String getUserName() {
			return userName;
		}

		public String getUserPassword() {
			return userPassword;
		}
		
		public String getDelegator() {
			return delegator;
		}
		
		

}